#ifndef DAILYMOTIONPLAYLISTLISTWINDOW_H
#define DAILYMOTIONPLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "dailymotionplaylistlistmodel.h"
#include "listview.h"
#include <QLabel>

class DailymotionPlaylistListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionPlaylistListWindow(Session *session, QWidget *parent);
    void setPlaylistFeed(const QString &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> laylist);

private:
    ListView *m_listView;
    DailymotionPlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONPLAYLISTLISTWINDOW_H
