#include "commentitem.h"
#include "utils.h"

CommentItem::CommentItem(const QVariantMap &comment, QObject *parent) :
    QObject(parent),
    m_id(comment.value("id").toString()),
    m_body(comment.value("message").toString()),
    m_artist(comment.value("owner.username").toString()),
    m_artistId(comment.value("owner.id").toString()),
    m_artistAvatarUrl(comment.value("owner.avatar_medium_url").toString()),
    m_date(Utils::dateFromSecs(comment.value("created_time").toLongLong())),
    m_videoId(comment.value("video.id").toString()),
    m_indent(0),
    m_loading(false)
{
}

CommentItem::CommentItem(const QDomNode &comment, QObject *parent) :
    QObject(parent),
    m_id(comment.firstChildElement("id").text().section(':', -1)),
    m_body(comment.firstChildElement("content").text()),
    m_artist(comment.firstChildElement("author").firstChildElement("name").text()),
    m_artistId(comment.firstChildElement("author").firstChildElement("yt:userId").text()),
    m_artistAvatarUrl("http://i2.ytimg.com/i/" + artistId() + "/1.jpg"),
    m_date(Utils::localDateTimeFromString(comment.firstChildElement("published").text())),
    m_videoId(comment.firstChildElement("yt:videoid").text()),
    m_replyId(comment.firstChildElement("link").attribute("href").section('/', -1).section('?', 0, 0)),
    m_indent(0),
    m_loading(false)
{
}
