#include "abstractgrouplistmodel.h"

AbstractGroupListModel::AbstractGroupListModel(QObject *parent) :
    QAbstractListModel(parent)
{
}

AbstractGroupListModel::~AbstractGroupListModel() {
    m_list.clear();
}

int AbstractGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_list.size();
}

QVariant AbstractGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case TitleRole:
        return m_list.at(index.row()).data()->title();
    case ArtistRole:
        return m_list.at(index.row()).data()->artist();
    case DateRole:
        return m_list.at(index.row()).data()->date();
    case DescriptionRole:
        return m_list.at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QSharedPointer<GroupItem> AbstractGroupListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<GroupItem>(m_list.at(row));
    }

    return QSharedPointer<GroupItem>();
}

void AbstractGroupListModel::insertGroup(int row, QSharedPointer<GroupItem> group) {
    beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, group);
    endInsertRows();
}

void AbstractGroupListModel::appendGroup(QSharedPointer<GroupItem> group) {
    beginInsertRows(QModelIndex(), rowCount(), rowCount());
    m_list.append(group);
    endInsertRows();
}

bool AbstractGroupListModel::removeGroup(const QString &id) {
    bool removed = false;
    int i = 0;

    while ((!removed) && (i < m_list.size())) {
        removed = (get(i).data()->id() == id);

        if (removed) {
            removeRow(i);
        }

        i++;
    }

    return removed;
}

bool AbstractGroupListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent);

    if ((row >= 0) && (row < m_list.size())) {
        beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        endRemoveRows();

        return true;
    }

    return false;
}
