#include "vimeousergrouplisttab.h"
#include "vimeogrouplistdelegate.h"
#include "vimeovideolistwindow.h"
#include "listview.h"
#include "../base/vimeousergrouplistmodel.h"
#include "../base/vimeo.h"
#include "../base/notifications.h"
#include "windowstack.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>
#include <QMaemo5Style>

VimeoUserGroupListTab::VimeoUserGroupListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new VimeoUserGroupListModel(this)),
    m_contextMenu(new QMenu(this)),
    m_leaveAction(m_contextMenu->addAction(tr("Leave group"), this, SLOT(leaveGroup()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new VimeoGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (Vimeo::instance()->groupsLoaded()) {
        this->onGroupsLoaded();
    }
    else {
        Notifications::toggleBusy(true);
        this->connect(Vimeo::instance(), SIGNAL(allGroupsLoaded()), this, SLOT(onGroupsLoaded()));
    }

    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));

    this->onOrientationChanged();
}

void VimeoUserGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoUserGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoUserGroupListTab::onGroupsLoaded() {
    Notifications::toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void VimeoUserGroupListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible(count == 0);
}

void VimeoUserGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void VimeoUserGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    VimeoVideoListWindow *window = new VimeoVideoListWindow(WindowStack::instance()->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}

void VimeoUserGroupListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_leaveAction);
}

void VimeoUserGroupListTab::leaveGroup() {
    Vimeo::instance()->leaveGroup(m_model->data(m_listView->currentIndex(), VimeoUserGroupListModel::IdRole).toString());
}
