#include "vimeorelatedvideostab.h"
#include "vimeoalbumdialog.h"
#include "videolistdelegate.h"
#include "vimeovideoinfowindow.h"
#include "vimeovideoselectionwindow.h"
#include "videoplaybackwindow.h"
#include "../base/notifications.h"
#include "../base/settings.h"
#include "../base/urlgrabber.h"
#include "../base/vimeo.h"
#include "windowstack.h"
#include "../base/transfermanager.h"
#include "../base/playbacklistmodel.h"
#include "../base/vimeovideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QGridLayout>
#include <QMenu>
#include <QMaemo5Style>

VimeoRelatedVideosTab::VimeoRelatedVideosTab(QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractTab(parent),
    m_video(video),
    m_model(new VimeoVideoListModel(this)),
    m_listView(new ListView(this)),
    m_addToLikesAction(new QAction(tr("Add to likes"), this)),
    m_addToAlbumAction(new QAction(tr("Add to album"), this)),
    m_watchLaterAction(new QAction(tr("Watch later"), this)),
    m_addToQueueAction(new QAction(tr("Add to playback queue"), this)),
    m_videoDownloadAction(new QAction(tr("Download"), this)),
    m_audioDownloadAction(new QAction(tr("Download (audio)"), this)),
    m_contextMenu(new QMenu(this)),
    m_addToLikesContextAction(m_contextMenu->addAction(tr("Add to likes"), this, SLOT(addVideoToLikes()))),
    m_addToAlbumContextAction(m_contextMenu->addAction(tr("Add to album"), this, SLOT(showAlbumDialog()))),
    m_watchLaterContextAction(m_contextMenu->addAction(tr("Watch later"), this, SLOT(addVideoToWatchLaterAlbum()))),
    m_addToQueueContextAction(m_contextMenu->addAction(tr("Add to playback queue"), this, SLOT(queueVideo()))),
    m_videoDownloadContextAction(m_contextMenu->addAction(tr("Download"), this, SLOT(addVideoDownload()))),
    m_audioDownloadContextAction(m_contextMenu->addAction(tr("Download (audio)"), this, SLOT(addAudioDownload()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No videos found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_addToLikesAction);
    this->addAction(m_addToAlbumAction);
    this->addAction(m_watchLaterAction);
    this->addAction(m_addToQueueAction);
    this->addAction(m_videoDownloadAction);
    this->addAction(m_audioDownloadAction);

    m_noResultsLabel->hide();
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);

    VideoListDelegate *delegate = new VideoListDelegate(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(delegate);

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(delegate, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(delegate, SIGNAL(play(QModelIndex)), this, SLOT(playVideo(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreVideos()));
    this->connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
    this->connect(m_addToLikesAction, SIGNAL(triggered()), this, SLOT(addVideosToLikes()));
    this->connect(m_addToAlbumAction, SIGNAL(triggered()), this, SLOT(addVideosToAlbum()));
    this->connect(m_watchLaterAction, SIGNAL(triggered()), this, SLOT(addVideosToWatchLaterAlbum()));
    this->connect(m_addToQueueAction, SIGNAL(triggered()), this, SLOT(queueVideos()));
    this->connect(m_videoDownloadAction, SIGNAL(triggered()), this, SLOT(addVideoDownloads()));
    this->connect(m_audioDownloadAction, SIGNAL(triggered()), this, SLOT(addAudioDownloads()));

    m_model->search(m_video.data()->title());

    this->setMenuActions();
    this->onOrientationChanged();
}

void VimeoRelatedVideosTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void VimeoRelatedVideosTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void VimeoRelatedVideosTab::setMenuActions() {
    bool signedIn = Vimeo::instance()->userSignedIn();

    m_addToLikesAction->setEnabled(signedIn);
    m_addToAlbumAction->setEnabled(signedIn);
    m_watchLaterAction->setEnabled(signedIn);
    m_addToLikesContextAction->setVisible(signedIn);
    m_addToAlbumContextAction->setVisible(signedIn);
    m_watchLaterContextAction->setVisible(signedIn);
}

void VimeoRelatedVideosTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void VimeoRelatedVideosTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void VimeoRelatedVideosTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showVideoInfo(m_model->get(index.row()));
    }
}

void VimeoRelatedVideosTab::showVideoInfo(QSharedPointer<VideoItem> video) {
    VimeoVideoInfoWindow *window = new VimeoVideoInfoWindow(video, WindowStack::instance()->currentWindow());
    window->show();
}

void VimeoRelatedVideosTab::playVideo(const QModelIndex &index) {
    if (Settings::instance()->mediaPlayer() == "cutetube") {
        VideoPlaybackWindow *window = new VideoPlaybackWindow(QList< QSharedPointer<VideoItem> >() << m_model->get(index.row()), WindowStack::instance()->currentWindow());
        window->show();
    }
    else {
        UrlGrabber::instance()->getVimeoVideoUrl(index.data(AbstractVideoListModel::VideoIdRole).toString());
    }
}

void VimeoRelatedVideosTab::addVideosToLikes() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Add to likes"), SLOT(addVideosToLikes()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::addVideosToAlbum() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Add to album"), SLOT(showAlbumDialog()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::addVideosToWatchLaterAlbum() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Watch later"), SLOT(addVideosToWatchLaterAlbum()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::addVideoDownloads() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Download"), SLOT(addVideoDownloads()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::addAudioDownloads() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Download"), SLOT(addAudioDownloads()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::queueVideos() {
    VimeoVideoSelectionWindow *window = new VimeoVideoSelectionWindow(m_model, tr("Add to queue"), SLOT(queueVideos()), WindowStack::instance()->currentWindow());
    window->positionAtIndex(m_listView->indexAt(QPoint(0, 0)));
    window->show();
}

void VimeoRelatedVideosTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_addToLikesContextAction);
}

void VimeoRelatedVideosTab::addVideoToLikes() {
    Vimeo::instance()->addToLikes(QStringList(m_model->data(m_listView->currentIndex(), AbstractVideoListModel::VideoIdRole).toString()));
}

void VimeoRelatedVideosTab::showAlbumDialog() {
    VimeoAlbumDialog *dialog = new VimeoAlbumDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(albumChosen(QString)), this, SLOT(addVideoToAlbum(QString)));
    this->connect(dialog, SIGNAL(addToNewAlbum(QVariantMap)), this, SLOT(addVideoToNewAlbum(QVariantMap)));
}

void VimeoRelatedVideosTab::addVideoToAlbum(const QString &id) {
    Vimeo::instance()->addToAlbum(QStringList(m_model->data(m_listView->currentIndex(), AbstractVideoListModel::VideoIdRole).toString()), id);
}

void VimeoRelatedVideosTab::addVideoToNewAlbum(const QVariantMap &album) {
    Vimeo::instance()->createAlbum(album, QStringList(m_model->data(m_listView->currentIndex(), AbstractVideoListModel::VideoIdRole).toString()));
}

void VimeoRelatedVideosTab::addVideoToWatchLaterAlbum() {
    Vimeo::instance()->addToWatchLaterAlbum(QStringList(m_model->data(m_listView->currentIndex(), AbstractVideoListModel::VideoIdRole).toString()));
}

void VimeoRelatedVideosTab::addVideoDownload() {
    TransferManager::instance()->addDownloadTransfer(m_model->get(m_listView->currentIndex().row()));
}

void VimeoRelatedVideosTab::addAudioDownload() {
    TransferManager::instance()->addDownloadTransfer(m_model->get(m_listView->currentIndex().row()), true);
}

void VimeoRelatedVideosTab::queueVideo() {
    PlaybackListModel::playbackQueue()->addVideo(m_model->get(m_listView->currentIndex().row()));
}
