#ifndef DAILYMOTIONPLAYLISTLISTWINDOW_H
#define DAILYMOTIONPLAYLISTLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/playlistitem.h"

class DailymotionPlaylistListModel;
class ListView;
class QLabel;
class QModelIndex;

class DailymotionPlaylistListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit DailymotionPlaylistListWindow(QWidget *parent);
    void setPlaylistFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> laylist);

private:
    ListView *m_listView;
    DailymotionPlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONPLAYLISTLISTWINDOW_H
