#ifndef DAILYMOTIONCOMMENTDIALOG_H
#define DAILYMOTIONCOMMENTDIALOG_H

#include "abstractdialog.h"
#include "../base/videoitem.h"

class QTextEdit;
class QPushButton;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;

class DailymotionCommentDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionCommentDialog(QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCommentTextChanged();
    void submitComment();

private:
    QSharedPointer<VideoItem> m_video;
    QTextEdit *m_commentEdit;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONCOMMENTDIALOG_H
