#include "youtubecategorymodel.h"
#include "feedurls.h"

YouTubeCategoryModel::YouTubeCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    m_time_filters[Queries::AllTime] = "all_time";
    m_time_filters[Queries::ThisWeek] = "this_week";
    m_time_filters[Queries::ThisMonth] = "this_month";

    this->addItem(tr("Cars & Vehicles"), this->feedFromValues("Autos"));
    this->addItem(tr("Comedy"), this->feedFromValues("Comedy"));
    this->addItem(tr("Education"), this->feedFromValues("Education"));
    this->addItem(tr("Entertainment"), this->feedFromValues("Entertainment"));
    this->addItem(tr("Film"), this->feedFromValues("Film"));
    this->addItem(tr("Gaming"), this->feedFromValues("Games"));
    this->addItem(tr("Most Popular (Today)"), this->feedFromValues("most_popular", true, Queries::Today));
    this->addItem(tr("Most Popular (This Week)"), this->feedFromValues("most_popular", true, Queries::ThisWeek));
    this->addItem(tr("Most Popular (This Month)"), this->feedFromValues("most_popular", true, Queries::ThisMonth));
    this->addItem(tr("Music"), this->feedFromValues("Music"));
    this->addItem(tr("News & Politics"), this->feedFromValues("News"));
    this->addItem(tr("Non-profits & Activism"), this->feedFromValues("Nonprofit"));
    this->addItem(tr("People"), this->feedFromValues("People"));
    this->addItem(tr("Pets & Animals"), this->feedFromValues("Animals"));
    this->addItem(tr("Science & Technology"), this->feedFromValues("Tech"));
    this->addItem(tr("Sport"), this->feedFromValues("Sports"));
    this->addItem(tr("Style"), this->feedFromValues("Howto"));
    this->addItem(tr("Travel & Events"), this->feedFromValues("Travel"));
    emit countChanged(this->rowCount());
}

QString YouTubeCategoryModel::feedFromValues(const QString &value, bool standard, Queries::TimeFilter time) {
    QString feed;

    if (standard) {
        feed = YOUTUBE_STANDARD_FEEDS_BASE_URL + QString("%1?v=2.1&max-results=30").arg(value);

        if (time != Queries::None) {
            feed.append(QString("&time=%1").arg(m_time_filters.value(time, "all_time")));
        }
    }
    else {
        feed = YOUTUBE_VIDEOS_BASE_URL + QString("?v=2.1&max-results=30&orderby=published&category=%1").arg(value);
    }

    return feed;
}
