#ifndef DAILYMOTIONCOMMENTLISTMODEL_H
#define DAILYMOTIONCOMMENTLISTMODEL_H

#include "abstractcommentlistmodel.h"

class DailymotionCommentListModel : public AbstractCommentListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed)
    Q_PROPERTY(QString videoId
               READ videoId
               WRITE setVideoId)

public:
    explicit DailymotionCommentListModel(QObject *parent = 0);
    inline QString videoId() const { return m_videoId; }
    void setVideoId(const QString &id = QString());
    inline QUrl feed() const { return m_feed; }
    inline void setFeed(const QUrl &feed) { m_feed = feed; }
    inline bool loading() const { return m_loading; }

public slots:
    void clear();
    void reset();
    void getComments(const QString &id = QString());
    void getMoreComments();

private slots:
    void addComments();
    inline void onError() { setError(true); setLoading(false); }
    inline void stopLoading() { this->setLoading(false); }
    void onCommentAdded(QSharedPointer<CommentItem> comment);

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);

private:
    QString m_videoId;
    QUrl m_feed;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // DAILYMOTIONCOMMENTLISTMODEL_H
