#include "cookiejar.h"
#include <QRegExp>

CookieJar::CookieJar(QObject *parent) :
    QNetworkCookieJar(parent)
{
}

QList<QNetworkCookie> CookieJar::cookiesForUrl(const QUrl &url) const {
    return url.toString().contains(QRegExp("dailymotion.com/(embed|video|cdn)")) ? QList<QNetworkCookie>() << QNetworkCookie("family_filter", "false")
                                                                                 : QNetworkCookieJar::cookiesForUrl(url);
}

void CookieJar::clearCookies() {
    this->setAllCookies(QList<QNetworkCookie>());
}
