#ifndef CONNECTION_H
#define CONNECTION_H

#include "enums.h"
#include "file.h"
#include <QNetworkRequest>

class QNetworkAccessManager;
class QNetworkReply;
class QFile;

class Connection : public QObject
{
    Q_OBJECT

public:
    explicit Connection(QNetworkAccessManager *manager, QObject *parent = 0);
    ~Connection();

    Transfers::TransferType transferType() const;
    void setTransferType(Transfers::TransferType);

    QString uploadFile() const;
    void setUploadFile(const QString &fileName);

    QNetworkRequest request() const;
    void setRequest(const QNetworkRequest &request);

    QByteArray header(const QByteArray &headerName) const;
    void setHeader(const QByteArray &headerName, const QByteArray &value);

    qint64 contentRangeStart() const;
    void setContentRangeStart(qint64 start);

    qint64 contentRangeEnd() const;
    void setContentRangeEnd(qint64 end);

    void setContentRange(qint64 start, qint64 end);

    qint64 position() const;

    Transfers::Status status() const;
    QString errorString() const;

public slots:
    void start();
    void pause();
    void cancel();
    void processData();

private:
    void setStatus(Transfers::Status status);
    void setErrorString(const QString &errorString);

private slots:
    void performDownload(const QUrl &url = QUrl());
    void performUpload(const QUrl &url = QUrl());
    void onMetaDataChanged();
    void onReadyRead();
    void onUploadProgressChanged(qint64 bytes);
    void onFinished();

signals:
    void dataAvailable(qint64 offset, const QByteArray &data);
    void bytesTransferred(qint64 bytes);
    void metaInfoReady(MetaInfo info);
    void statusChanged(Transfers::Status status);
    
private:
    QNetworkAccessManager *m_nam;
    QNetworkReply *m_reply;
    QFile *m_uploadFile;
    Transfers::TransferType m_transferType;
    QNetworkRequest m_request;
    qint64 m_start;
    qint64 m_end;
    qint64 m_transferredBytes;
    QByteArray m_buffer;
    Transfers::Status m_status;
    QString m_errorString;
};

#endif // CONNECTION_H
