#include "abstractuserlistmodel.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

AbstractUserListModel::AbstractUserListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    m_roleNames[IdRole] = "id";
    m_roleNames[SubscriptionIdRole] = "subscriptionId";
    m_roleNames[UsernameRole] = "username";
    m_roleNames[ChannelNameRole] = "channelName";
#ifndef QML_USER_INTERFACE
    m_roleNames[AvatarRole] = "avatar";
#endif
    m_roleNames[AvatarUrlRole] = "avatarUrl";
    m_roleNames[VideoCountRole] = "videoCount";
    m_roleNames[DescriptionRole] = "description";
    m_roleNames[ViewCountRole] = "viewCount";
    m_roleNames[SubscriberCountRole] = "subscriberCount";
    m_roleNames[SubscriptionRole] = "subscription";
    m_roleNames[ServiceRole] = "service";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
}

AbstractUserListModel::~AbstractUserListModel() {
    m_list.clear();
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> AbstractUserListModel::roleNames() const {
    return m_roleNames;
}
#endif

void AbstractUserListModel::clear() {
    this->beginResetModel();
    m_list.clear();
    this->endResetModel();
}

int AbstractUserListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant AbstractUserListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_list.at(index.row()).data()->id();
    case SubscriptionIdRole:
        return m_list.at(index.row()).data()->subscriptionId();
    case UsernameRole:
        return m_list.at(index.row()).data()->username();
    case ChannelNameRole:
        return m_list.at(index.row()).data()->channelName();
#ifndef QML_USER_INTERFACE
    case AvatarRole:
        return m_cache->thumbnail(m_list.at(index.row()).data()->avatarUrl(), QSize(60, 60));
#endif
    case AvatarUrlRole:
        return m_list.at(index.row()).data()->avatarUrl();
    case VideoCountRole:
        return m_list.at(index.row()).data()->videoCount();
    case SubscriberCountRole:
        return m_list.at(index.row()).data()->subscriberCount();
    case SubscriptionRole:
        return m_list.at(index.row()).data()->subscription();
    case ServiceRole:
        return m_list.at(index.row()).data()->service();
    default:
        return QVariant();
    }
}

QVariant AbstractUserListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<UserItem> AbstractUserListModel::get(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return QSharedPointer<UserItem>(m_list.at(row));
    }

    return QSharedPointer<UserItem>();
}

#ifdef QML_USER_INTERFACE
UserItem* AbstractUserListModel::getFromQML(int row) const {
    if ((row >= 0) && (row < m_list.size())) {
        return m_list.at(row).data();
    }

    return 0;
}
#endif

void AbstractUserListModel::insertUser(int row, QSharedPointer<UserItem> user) {
    this->beginInsertRows(QModelIndex(), row, row);
    m_list.insert(row, user);
    this->endInsertRows();
}

void AbstractUserListModel::appendUser(QSharedPointer<UserItem> user) {
    this->beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
    m_list.append(user);
    this->endInsertRows();
}

bool AbstractUserListModel::removeUser(const QVariant &value, int role) {
    QModelIndexList indexes = this->match(this->index(0), role, value, 1, Qt::MatchExactly);

    if (indexes.isEmpty()) {
        return false;
    }

    return this->removeRow(indexes.first().row());
}

bool AbstractUserListModel::removeRow(int row, const QModelIndex &parent)
{
    Q_UNUSED(parent)

    if ((row >= 0) && (row < m_list.size())) {
        this->beginRemoveRows(QModelIndex(), row, row);
        m_list.takeAt(row).clear();
        this->endRemoveRows();

        return true;
    }

    return false;
}

#ifndef QML_USER_INTERFACE
void AbstractUserListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
