#ifndef VIMEOCHANNELWINDOW_H
#define VIMEOCHANNELWINDOW_H

#include "stackedwindow.h"

class VimeoProfileTab;
class VimeoVideoListTab;
class VimeoAlbumListTab;
class VimeoGroupListTab;
class VimeoUserListTab;
class QStackedWidget;
class QActionGroup;
class QMenu;

class VimeoChannelWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit VimeoChannelWindow(const QString &userId, QWidget *parent);

private:
    void clearMenuActions();

private slots:
    void showProfile();
    void showUploads();
    void showLikes();
    void showAlbums();
    void showGroups();
    void showSubscriptions();

private:
    QString m_userId;
    QMenu *m_menu;
    QActionGroup *m_actionGroup;
    QAction *m_profileAction;
    QAction *m_uploadsAction;
    QAction *m_likesAction;
    QAction *m_albumsAction;
    QAction *m_groupsAction;
    QAction *m_subscriptionsAction;
    QStackedWidget *m_tabWidget;
    VimeoProfileTab *m_profileTab;
    VimeoVideoListTab *m_uploadsTab;
    VimeoVideoListTab *m_likesTab;
    VimeoAlbumListTab *m_albumsTab;
    VimeoGroupListTab *m_groupsTab;
    VimeoUserListTab *m_subscriptionsTab;
};

#endif // VIMEOCHANNELWINDOW_H
