#ifndef DAILYMOTIONCATEGORIESDIALOG_H
#define DAILYMOTIONCATEGORIESDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class DailymotionCategoryModel;
class ListView;
class QModelIndex;

class DailymotionCategoriesDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionCategoriesDialog(QWidget *parent = 0);

private slots:
    void onCategoryChosen(const QModelIndex &index);

signals:
    void categoryChosen(Services::VideoService, const QString &title, const QUrl &feed);

private:
    DailymotionCategoryModel *m_model;
    ListView *m_view;
};

#endif // DAILYMOTIONCATEGORIESDIALOG_H
