#ifndef TRANSFERMANAGER_H
#define TRANSFERMANAGER_H

#include "transferitem.h"
#include "videoitem.h"
#include <QSharedPointer>

class QTimer;

class TransferManager : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int totalTransfers
               READ totalTransfers
               NOTIFY totalTransfersChanged)
    Q_PROPERTY(int activeTransfers
               READ activeTransfers
               NOTIFY activeTransfersChanged)

public:
    explicit TransferManager(QObject *parent = 0);
    ~TransferManager();

    Q_INVOKABLE void addDownloadTransfer(VideoItem *video, bool convertToAudio = false, bool notify = true);
    void addDownloadTransfer(QSharedPointer<VideoItem> video, bool convertToAudio = false, bool notify = true);

    Q_INVOKABLE void addDownloadTransfers(QList<VideoItem*> videos, bool convertToAudio = false);
    void addDownloadTransfers(QList< QSharedPointer<VideoItem> >videos, bool convertToAudio = false);

    Q_INVOKABLE void addUploadTransfer(const QVariantMap &metadata);

    QSharedPointer<TransferItem> get(int i) const;
    QSharedPointer<TransferItem> get(const QString &id) const;

    int totalTransfers() const;

    int activeTransfers() const;

    static TransferManager* instance();

public slots:
    bool start();
    bool pause();
    bool start(const QString &id);
    bool pause(const QString &id);
    bool cancel(const QString &id);

    void storeTransfers();
    void restoreStoredTransfers();

private:
    void getNextTransfers();

    void removeTransfer(TransferItem *transfer);

    void addActiveTransfer(QSharedPointer<TransferItem> transfer);
    void removeActiveTransfer(TransferItem *transfer);

private slots:
    void startNextTransfers();
    void onTransferStatusChanged(Transfers::Status status);
    void onMaximumConcurrentTransfersChanged(int oldMaximum, int newMaximum);

signals:
    void totalTransfersChanged(int total);
    void activeTransfersChanged(int active);
    void alert(const QString &message);

private:
    static TransferManager *self;

    QTimer *m_queueTimer;

    QList< QSharedPointer<TransferItem> > m_transfers;
    QList< QSharedPointer<TransferItem> > m_activeTransfers;
};

#endif // TRANSFERMANAGER_H
