#include "dailymotionusergrouplistmodel.h"
#include "dailymotion.h"

DailymotionUserGroupListModel::DailymotionUserGroupListModel(QObject *parent) :
    QAbstractListModel(parent)
{
    m_roleNames[IdRole] = "id";
    m_roleNames[TitleRole] = "title";
    m_roleNames[ArtistRole] = "artist";
    m_roleNames[DateRole] = "date";
    m_roleNames[DescriptionRole] = "description";
#if QT_VERSION < 0x050000
    this->setRoleNames(m_roleNames);
#endif

    if (!Dailymotion::instance()->groupsLoaded()) {
        Dailymotion::instance()->getGroups();
    }

    this->connect(Dailymotion::instance(), SIGNAL(groupAddedToCache(int)), this, SLOT(onGroupAdded(int)));
    this->connect(Dailymotion::instance(), SIGNAL(groupRemovedFromCache(int)), this, SLOT(onGroupRemoved(int)));
}

#if QT_VERSION >= 0x050000
QHash<int, QByteArray> DailymotionUserGroupListModel::roleNames() const {
    return m_roleNames;
}
#endif

void DailymotionUserGroupListModel::onGroupAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void DailymotionUserGroupListModel::onGroupRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

int DailymotionUserGroupListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Dailymotion::instance()->groups()->size();
}

QVariant DailymotionUserGroupListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Dailymotion::instance()->groups()->at(index.row()).data()->id();
    case TitleRole:
        return Dailymotion::instance()->groups()->at(index.row()).data()->title();
    case ArtistRole:
        return Dailymotion::instance()->groups()->at(index.row()).data()->artist();
    case DateRole:
        return Dailymotion::instance()->groups()->at(index.row()).data()->date();
    case DescriptionRole:
        return Dailymotion::instance()->groups()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant DailymotionUserGroupListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<GroupItem> DailymotionUserGroupListModel::get(int row) const {
    return QSharedPointer<GroupItem>(Dailymotion::instance()->groups()->at(row));
}

#ifdef QML_USER_INTERFACE
GroupItem* DailymotionUserGroupListModel::getFromQML(int row) const {
    return Dailymotion::instance()->groups()->at(row).data();
}
#endif
