#ifndef YOUTUBECOMMENTDIALOG_H
#define YOUTUBECOMMENTDIALOG_H

#include "abstractdialog.h"
#include "../base/commentitem.h"
#include "../base/videoitem.h"

class ThumbnailLabel;
class QTextEdit;
class QLabel;
class QPushButton;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;

class YouTubeCommentDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeCommentDialog(QSharedPointer<VideoItem> video, QSharedPointer<CommentItem> initialComment = QSharedPointer<CommentItem>(), QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onCommentTextChanged();
    void setAvatar();
    void submitComment();

private:
    QSharedPointer<VideoItem> m_video;
    QSharedPointer<CommentItem> m_initialComment;
    QTextEdit *m_commentEdit;
    ThumbnailLabel *m_avatar;
    QLabel *m_initialCommentLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBECOMMENTDIALOG_H
