#ifndef VIMEOALBUMDIALOG_H
#define VIMEOALBUMDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class VimeoUserAlbumListModel;
class ListView;
class QDialogButtonBox;
class QPushButton;
class QLabel;
class QGridLayout;
class QModelIndex;

class VimeoAlbumDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit VimeoAlbumDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showNewAlbumDialog();
    void onItemClicked(const QModelIndex &index);
    void onAlbumsLoaded();

signals:
    void albumChosen(const QString &id);
    void addToNewAlbum(const QVariantMap &album);

private:
    VimeoUserAlbumListModel *m_model;
    ListView *m_listView;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_newButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOALBUMDIALOG_H
