#ifndef DAILYMOTIONUSERLISTWINDOW_H
#define DAILYMOTIONUSERLISTWINDOW_H

#include "stackedwindow.h"

class DailymotionUserListModel;
class ListView;
class QLabel;
class QModelIndex;

class DailymotionUserListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit DailymotionUserListWindow(QWidget *parent);
    void setFeed(const QUrl &feed);
    void search(const QString &query);

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showUserChannel(const QString &userId);

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

private:
    DailymotionUserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONUSERLISTWINDOW_H
