#ifndef ABSTRACTUSERLISTMODEL_H
#define ABSTRACTUSERLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class AbstractUserListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
#ifndef QML_USER_INTERFACE
        AvatarRole,
#endif
        AvatarUrlRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole,
        ServiceRole
    };

public:
    explicit AbstractUserListModel(QObject *parent = 0);
    ~AbstractUserListModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<UserItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE UserItem* getFromQML(int row) const;
#endif

public slots:
    void clear();
    void insertUser(int row, QSharedPointer<UserItem> user);
    void appendUser(QSharedPointer<UserItem> user);
    bool removeUser(const QVariant &value, int role = IdRole);
    
protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

#ifndef QML_USER_INTERFACE
protected slots:
    void onThumbnailReady();
#endif

protected:
#ifndef QML_USER_INTERFACE
    ThumbnailCache *m_cache;
#endif
    QList< QSharedPointer<UserItem> > m_list;
    QHash<int, QByteArray> m_roleNames;
};

#endif // ABSTRACTUSERLISTMODEL_H
