#ifndef YOUTUBE_H
#define YOUTUBE_H

#include "../../cutetubeapp/src/base/enums.h"
#include <QObject>
#include <QString>
#include <QUrl>

class QNetworkAccessManager;
class QNetworkReply;

class YouTube : public QObject
{
    Q_OBJECT

public:
    explicit YouTube(QObject *parent = 0);
    ~YouTube();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    inline QString username() const { return m_user; }
    inline bool userSignedIn() const { return !this->accessToken().isEmpty(); }
    QNetworkReply* createReply(QString feed, int offset = 0);
    inline QString accessToken() const { return m_token; }
    inline QString developerKey() const { return m_key; }

public slots:
    void setAccount(const QString &user = QString(), const QString &token = QString(), const QString &refresh = QString());
    inline void setUsername(const QString &user) { m_user = user; emit usernameChanged(user); }
    void refreshAccessToken();

private:
    inline void setAccessToken(const QString &token) { m_token = token; emit userSignedInChanged(); }
    inline QString refreshToken() const { return m_refreshToken; }
    inline void setRefreshToken(const QString &token) { m_refreshToken = token; }

private slots:
    void checkTokenRefresh();

signals:
    void usernameChanged(const QString &username);
    void userSignedInChanged();
    void newAccountSet();
    void accessTokenRefreshed(const QString &token);
    void refreshError();

private:
    QNetworkAccessManager *m_nam;
    QString m_clientId;
    QString m_clientSecret;
    QString m_key;
    QString m_user;
    QString m_token;
    QString m_refreshToken;
};

#endif // YOUTUBE_H
