#include "youtube.h"
#include "../../cutetubeapp/src/base/json.h"
#include "../../cutetubeapp/src/base/definitions.h"
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QDebug>
#if QT_VERSION >= 0x050000
#include <QUrlQuery>
#endif

using namespace QtJson;

YouTube::YouTube(QObject *parent) :
    QObject(parent),
    m_nam(0),
    m_clientId("446197852855.apps.googleusercontent.com"),
    m_clientSecret("YzuBGnTyRdz9cK5J3Pg5Xlte"),
    m_key("AI39si6x9O1gQ1Z_BJqo9j2n_SdVsHu1pk2uqvoI3tVq8d6alyc1og785IPCkbVY3Q5MFuyt-IFYerMYun0MnLdQX5mo2BueSw")
{
}

YouTube::~YouTube() {}

QNetworkReply* YouTube::createReply(QString feed, int offset) {
    QUrl url(feed);
#if QT_VERSION >= 0x050000
    QUrlQuery query(url);

    if (this->userSignedIn()) {
        query.addQueryItem("access_token", this->accessToken());
    }

    if (offset) {
        query.addQueryItem("start-index", QString::number(offset));
    }

    url.setQuery(query);
#else
    if (this->userSignedIn()) {
        url.addQueryItem("access_token", this->accessToken());
    }

    if (offset) {
        url.addQueryItem("start-index", QString::number(offset));
    }
#endif
    qDebug() << url;

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("cuteTube/%1 (Qt)").arg(VERSION_NUMBER).toUtf8());
    request.setRawHeader("X-Gdata-Key", "key=" + this->developerKey().toUtf8());

    return this->networkAccessManager()->get(request);
}

void YouTube::refreshAccessToken() {
    QUrl url("https://accounts.google.com/o/oauth2/token");

    QByteArray body("client_id=" + m_clientId.toUtf8() +
                    "&client_secret=" + m_clientSecret.toUtf8() +
                    "&refresh_token=" + refreshToken().toUtf8() +
                    "&grant_type=refresh_token");

    QNetworkRequest request(url);
    request.setRawHeader("User-Agent", QString("cuteTube/%1 (Qt)").arg(VERSION_NUMBER).toUtf8());
    request.setHeader(QNetworkRequest::ContentTypeHeader, "application/x-www-form-urlencoded");
    QNetworkReply *reply = this->networkAccessManager()->post(request, body);
    this->connect(reply, SIGNAL(finished()), this, SLOT(checkTokenRefresh()));
}

void YouTube::checkTokenRefresh() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        emit refreshError();
        return;
    }

    QString response(reply->readAll());
    bool ok;
    QVariantMap result = Json::parse(response, ok).toMap();

    if (!ok) {
        emit refreshError();
    }
    else {
        QString token = result.value("access_token").toString();

        if (token.isEmpty()) {
            QString error = result.value("error").toString();

            if (error == "invalid_request") {
                emit refreshError();
                this->setAccount();
            }
            else {
                emit refreshError();
            }
        }
        else {
            this->setAccessToken(token);
            emit accessTokenRefreshed(token);
        }
    }

    reply->deleteLater();
}

void YouTube::setAccount(const QString &user, const QString &token, const QString &refresh) {
    if (user != this->username()) {
        this->setUsername(user);
    }

    this->setAccessToken(token);
    this->setRefreshToken(refresh);

    if ((user.isEmpty()) && (!token.isEmpty())) {
        emit newAccountSet();
    }
}
