#ifndef TRANSFERLISTWINDOW_H
#define TRANSFERLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/enums.h"

class TransferListModel;
class ListView;
class QLabel;
class QMenu;
class QAction;
class QModelIndex;

class TransferListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit TransferListWindow(QWidget *parent);
    ~TransferListWindow();

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void showPriorityDialog();
    void setTransferPriority(Transfers::Priority priority);
    void pauseOrResumeTransfer();
    void cancelTransfer();
    void onCountChanged(int count);
    
private:
    TransferListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
    QMenu *m_contextMenu;
    QAction *m_priorityAction;
    QAction *m_pauseResumeAction;
    QAction *m_cancelAction;
    QAction *m_startAction;
    QAction *m_pauseAction;
};

#endif // TRANSFERLISTWINDOW_H
