#include "homewindow.h"
#include "aboutdialog.h"
#include "settingsdialog.h"
#include "accountsdialog.h"
#include "searchdialog.h"
#include "youtubecategoriesdialog.h"
#include "dailymotioncategoriesdialog.h"
#include "vimeocategoriesdialog.h"
#include "querydialog.h"
#include "videoservicedialog.h"
#include "linkgoogleaccountdialog.h"
#include "facebookauthdialog.h"
#include "twitterauthdialog.h"
#include "youtubemychannelwindow.h"
#include "dailymotionmychannelwindow.h"
#include "vimeomychannelwindow.h"
#include "youtubevideolistwindow.h"
#include "dailymotionvideolistwindow.h"
#include "youtubeplaylistlistwindow.h"
#include "dailymotionplaylistlistwindow.h"
#include "youtubeuserlistwindow.h"
#include "dailymotionuserlistwindow.h"
#include "dailymotiongrouplistwindow.h"
#include "playbackqueuewindow.h"
#include "transferlistwindow.h"
#include "vimeovideolistwindow.h"
#include "socialvideolistwindow.h"
#include "archivewindow.h"
#include "navbutton.h"
#include "resourceloader.h"
#include "../base/feedurls.h"
#include "../base/sharing.h"
#include "../base/youtube.h"
#include "../base/dailymotion.h"
#include "../base/vimeo.h"
#include "windowstack.h"
#include "../base/settings.h"
#include "../base/clipboardmonitor.h"
#include <QGridLayout>
#include <QAction>
#include <QMenuBar>

HomeWindow::HomeWindow(QWidget *parent) :
    StackedWindow(parent),
    m_myChannelButton(new NavButton(tr("My Channel"), ":/images/mychannel.png", this)),
    m_latestButton(new NavButton(tr("Latest Videos"), ":/images/latest.png", this)),
    m_categoriesButton(new NavButton(tr("Categories"), ":/images/categories.png", this)),
    m_socialButton(new NavButton(tr("Social"), ":/images/social.png", this)),
    m_searchButton(new NavButton(tr("Search"), ":/images/search.png", this)),
    m_queueButton(new NavButton(tr("Queue"), ":/images/queue.png", this)),
    m_transfersButton(new NavButton(tr("Transfers"), ":/images/transfers.png", this)),
    m_archiveButton(new NavButton(tr("Archive"), ":/images/archive.png", this)),
    m_accountsButton(new NavButton(tr("Accounts"), ":/images/accounts.png", this)),
    m_accountsAction(this->menuBar()->addAction(tr("Accounts"), this, SLOT(showAccounts()))),
    m_settingsAction(this->menuBar()->addAction(tr("Settings"), this, SLOT(showSettingsDialog()))),
    m_aboutAction(this->menuBar()->addAction(tr("About"), this, SLOT(showAboutDialog()))),
    m_grid(0)
{    
    this->setWindowTitle("cuteTube");
    this->setAttribute(Qt::WA_DeleteOnClose, false);
    this->setCentralWidget(new QWidget(this));
    m_grid = new QGridLayout(centralWidget());
    m_grid->setContentsMargins(0, 0, 0, 0);

    this->connect(m_myChannelButton, SIGNAL(clicked()), this, SLOT(showMyChannel()));
    this->connect(m_latestButton, SIGNAL(clicked()), this, SLOT(showLatestVideos()));
    this->connect(m_categoriesButton, SIGNAL(clicked()), this, SLOT(showCategoriesDialog()));
    this->connect(m_socialButton, SIGNAL(clicked()), this, SLOT(showSocialVideos()));
    this->connect(m_searchButton, SIGNAL(clicked()), this, SLOT(showSearchDialog()));
    this->connect(m_queueButton, SIGNAL(clicked()), this, SLOT(showPlaybackQueue()));
    this->connect(m_transfersButton, SIGNAL(clicked()), this, SLOT(showTransfers()));
    this->connect(m_archiveButton, SIGNAL(clicked()), this, SLOT(showArchive()));
    this->connect(m_accountsButton, SIGNAL(clicked()), this, SLOT(showAccounts()));
    this->connect(YouTube::instance(), SIGNAL(requestToLinkGoogleAccount()), this, SLOT(showLinkGoogleAccountDialog()));
    this->connect(Sharing::instance(), SIGNAL(reauthenticateForFacebook()), this, SLOT(showFacebookAuthDialog()));
    this->connect(Sharing::instance(), SIGNAL(reauthenticateForTwitter()), this, SLOT(showTwitterAuthDialog()));
    this->connect(ClipboardMonitor::instance(), SIGNAL(gotClipboardUrl(QString)), ResourceLoader::instance(), SLOT(display(QString)));

    this->onOrientationChanged();
}

void HomeWindow::setLandscapeLayout() {
    m_accountsButton->hide();
    m_accountsAction->setEnabled(true);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->addWidget(m_socialButton, 0, 3);
        m_grid->addWidget(m_searchButton, 1, 0);
        m_grid->addWidget(m_queueButton, 1, 1);
        m_grid->addWidget(m_transfersButton, 1, 2);
        m_grid->addWidget(m_archiveButton, 1, 3);
    }
}

void HomeWindow::setPortraitLayout() {
    m_accountsButton->show();
    m_accountsAction->setEnabled(false);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_myChannelButton, 0, 0);
        m_grid->addWidget(m_latestButton, 0, 1);
        m_grid->addWidget(m_categoriesButton, 0, 2);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
    else {
        m_grid->removeWidget(m_socialButton);
        m_grid->removeWidget(m_searchButton);
        m_grid->removeWidget(m_queueButton);
        m_grid->removeWidget(m_transfersButton);
        m_grid->removeWidget(m_archiveButton);
        m_grid->removeWidget(m_accountsButton);
        m_grid->addWidget(m_socialButton, 1, 0);
        m_grid->addWidget(m_searchButton, 1, 1);
        m_grid->addWidget(m_queueButton, 1, 2);
        m_grid->addWidget(m_transfersButton, 2, 0);
        m_grid->addWidget(m_archiveButton, 2, 1);
        m_grid->addWidget(m_accountsButton, 2, 2);
    }
}

void HomeWindow::showSettingsDialog() {
    SettingsDialog *dialog = new SettingsDialog(this);
    dialog->open();
}

void HomeWindow::showAboutDialog() {
    AboutDialog *dialog = new AboutDialog(this);
    dialog->open();
}

void HomeWindow::showMyChannel(Services::VideoService service) {
    switch (service) {
    case Services::YouTube:
        this->showYouTubeChannel();
        return;
    case Services::Dailymotion:
        this->showDailymotionChannel();
        return;
    case Services::Vimeo:
        this->showVimeoChannel();
        return;
    default:
        bool signedInToYouTube = YouTube::instance()->userSignedIn();
        bool signedInToDailymotion = Dailymotion::instance()->userSignedIn();
        bool signedInToVimeo = Vimeo::instance()->userSignedIn();
        int accounts = 0;

        if (signedInToYouTube) {
            accounts++;
        }
        if (signedInToDailymotion) {
            accounts++;
        }
        if (signedInToVimeo) {
            accounts++;
        }

        if (accounts > 1) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            this->connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showMyChannel(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            this->showYouTubeChannel();
        }
        else if (signedInToDailymotion) {
            this->showDailymotionChannel();
        }
        else if (signedInToVimeo) {
            this->showVimeoChannel();
        }
        else {
            this->showSignInDialog();
        }

        return;
    }
}

void HomeWindow::showYouTubeChannel() {
    if (YouTube::instance()->userSignedIn()) {
        YouTubeMyChannelWindow *window = new YouTubeMyChannelWindow(this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showDailymotionChannel() {
    if (Dailymotion::instance()->userSignedIn()) {
        DailymotionMyChannelWindow *window = new DailymotionMyChannelWindow(this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showVimeoChannel() {
    if (Vimeo::instance()->userSignedIn()) {
        VimeoMyChannelWindow *window = new VimeoMyChannelWindow(this);
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestVideos(Services::VideoService service) {
    switch (service) {
    case Services::YouTube:
        this->showLatestYouTubeVideos();
        return;
    case Services::Dailymotion:
        this->showLatestDailymotionVideos();
        return;
    case Services::Vimeo:
        this->showLatestVimeoVideos();
        return;
    default:
    {
        bool signedInToYouTube = YouTube::instance()->userSignedIn();
        bool signedInToDailymotion = Dailymotion::instance()->userSignedIn();
        bool signedInToVimeo = Vimeo::instance()->userSignedIn();
        int accounts = 0;

        if (signedInToYouTube) {
            accounts++;
        }
        if (signedInToDailymotion) {
            accounts++;
        }
        if (signedInToVimeo) {
            accounts++;
        }

        if (accounts > 1) {
            VideoServiceDialog *dialog = new VideoServiceDialog(this);
            dialog->open();
            this->connect(dialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showLatestVideos(Services::VideoService)));
        }
        else if (signedInToYouTube) {
            this->showLatestYouTubeVideos();
        }
        else if (signedInToDailymotion) {
            this->showLatestDailymotionVideos();
        }
        else if (signedInToVimeo) {
            this->showLatestVimeoVideos();
        }
        else {
            this->showSignInDialog();
        }
    }
        return;
    }
}

void HomeWindow::showLatestYouTubeVideos() {
    if (YouTube::instance()->userSignedIn()) {
        YouTubeVideoListWindow *window = new YouTubeVideoListWindow(this);
        window->setVideoFeed(YOUTUBE_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestDailymotionVideos() {
    if (Dailymotion::instance()->userSignedIn()) {
        DailymotionVideoListWindow *window = new DailymotionVideoListWindow(this);
        window->setVideoFeed(DAILYMOTION_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showLatestVimeoVideos() {
    if (Vimeo::instance()->userSignedIn()) {
        VimeoVideoListWindow *window = new VimeoVideoListWindow(this);
        window->setVideoFeed(VIMEO_NEW_SUBSCRIPTION_VIDEOS_FEED);
        window->setWindowTitle(tr("Latest subscription videos"));
        window->show();
    }
    else {
        this->showSignInDialog();
    }
}

void HomeWindow::showCategoriesDialog(Services::VideoService service) {
    switch (service) {
    case Services::NoService:
    {
        VideoServiceDialog *serviceDialog = new VideoServiceDialog(this);
        serviceDialog->open();
        this->connect(serviceDialog, SIGNAL(valueChanged(Services::VideoService)), this, SLOT(showCategoriesDialog(Services::VideoService)));
    }
        return;
    case Services::YouTube:
    {
        YouTubeCategoriesDialog *youtubeDialog = new YouTubeCategoriesDialog(this);
        youtubeDialog->open();
        this->connect(youtubeDialog, SIGNAL(categoryChosen(Services::VideoService,QString,QUrl)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QUrl)));
    }
        return;
    case Services::Dailymotion:
    {
        DailymotionCategoriesDialog *dailymotionDialog = new DailymotionCategoriesDialog(this);
        dailymotionDialog->open();
        this->connect(dailymotionDialog, SIGNAL(categoryChosen(Services::VideoService,QString,QUrl)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QUrl)));
    }
        return;
    case Services::Vimeo:
    {
        VimeoCategoriesDialog *vimeoDialog = new VimeoCategoriesDialog(this);
        vimeoDialog->open();
        this->connect(vimeoDialog, SIGNAL(categoryChosen(Services::VideoService,QString,QUrl)), this, SLOT(showCategoryVideos(Services::VideoService,QString,QUrl)));
    }
        return;
    default:
        qWarning() << "HomeWindow::showCategoriesDialog(): Invalid service";
        return;
    }
}

void HomeWindow::showCategoryVideos(Services::VideoService service, const QString &title, const QUrl &feed) {
    switch (service) {
    case Services::YouTube:
    {
        YouTubeVideoListWindow *youtubeWindow = new YouTubeVideoListWindow(this);
        youtubeWindow->setVideoFeed(feed);
        youtubeWindow->setWindowTitle(title);
        youtubeWindow->show();
    }
        return;
    case Services::Dailymotion:
    {
        DailymotionVideoListWindow *dailymotionWindow = new DailymotionVideoListWindow(this);
        dailymotionWindow->setVideoFeed(feed);
        dailymotionWindow->setWindowTitle(title);
        dailymotionWindow->show();
    }
        return;
    case Services::Vimeo:
    {
        VimeoVideoListWindow *vimeoWindow = new VimeoVideoListWindow(this);
        vimeoWindow->setVideoFeed(feed);
        vimeoWindow->setWindowTitle(title);
        vimeoWindow->show();
    }
        return;
    default:
        qWarning() << "HomeWindow::showCategoryVideos(): Invalid service";
        return;
    }
}

void HomeWindow::showSocialVideos() {
    if ((Sharing::instance()->userSignedInToFacebook()) || (Sharing::instance()->userSignedInToTwitter())) {
        SocialVideoListWindow *window = new SocialVideoListWindow(this);
        window->show();
    }
    else {
        this->showSocialSignInDialog();
    }
}

void HomeWindow::showSearchDialog() {
    SearchDialog *dialog = new SearchDialog(this);
    dialog->open();

    this->connect(dialog, SIGNAL(search(QString)), this, SLOT(search(QString)));
}

void HomeWindow::search(const QString &query) {
    if (!ResourceLoader::instance()->display(query, false)) {
        this->search(query,
                     Settings::instance()->searchSite(),
                     Settings::instance()->searchType(),
                     Settings::instance()->searchOrder(),
                     Settings::instance()->searchTime(),
                     Settings::instance()->searchDuration(),
                     Settings::instance()->languageFilter());
    }
}

void HomeWindow::search(const QString &query, Services::VideoService service, Queries::QueryType type, Queries::QueryOrder order, Queries::TimeFilter timeFilter, Queries::DurationFilter durationFilter, const QString &languageFilter) {
    switch (type) {
    case Queries::Videos:
        this->videoSearch(query, service, order, timeFilter, durationFilter, languageFilter);
        return;
    case Queries::Playlists:
        this->playlistSearch(query, service, order);
        return;
    case Queries::Users:
        this->userSearch(query, service);
        return;
    case Queries::Groups:
        this->groupSearch(query, service, order);
        return;
    default:
        qWarning() << "HomeWindow::search(): Invalid query type.";
        return;
    }
}

void HomeWindow::videoSearch(const QString &query, Services::VideoService service, Queries::QueryOrder order, Queries::TimeFilter timeFilter, Queries::DurationFilter durationFilter, const QString &languageFilter) {
    switch (service) {
    case Services::YouTube:
    {
        YouTubeVideoListWindow *youtubeWindow = new YouTubeVideoListWindow(this);
        youtubeWindow->search(query, order, timeFilter, durationFilter, languageFilter);
        youtubeWindow->show();
    }
        return;
    case Services::Dailymotion:
    {
        DailymotionVideoListWindow *dailymotionWindow = new DailymotionVideoListWindow(this);
        dailymotionWindow->search(query, order, languageFilter);
        dailymotionWindow->show();
    }
        return;
    case Services::Vimeo:
    {
        VimeoVideoListWindow *vimeoWindow = new VimeoVideoListWindow(this);
        vimeoWindow->search(query, order);
        vimeoWindow->show();
    }
        return;
    default:
        qWarning() << "HomeWindow::videoSearch(): Invalid service";
        return;
    }
}

void HomeWindow::playlistSearch(const QString &query, Services::VideoService service, Queries::QueryOrder order) {
    switch (service) {
    case Services::YouTube:
    {
        YouTubePlaylistListWindow *youtubeWindow = new YouTubePlaylistListWindow(this);
        youtubeWindow->search(query, order);
        youtubeWindow->show();
    }
        return;
    case Services::Dailymotion:
    {
        DailymotionPlaylistListWindow *dailymotionWindow = new DailymotionPlaylistListWindow(this);
        dailymotionWindow->search(query, order);
        dailymotionWindow->show();
    }
        return;
    default:
        qWarning() << "HomeWindow::playlistSearch(): Invalid service";
        return;
    }
}

void HomeWindow::groupSearch(const QString &query, Services::VideoService service, Queries::QueryOrder order) {
    switch (service) {
    case Services::Dailymotion:
    {
        DailymotionGroupListWindow *window = new DailymotionGroupListWindow(this);
        window->search(query, order);
        window->show();
    }
        return;
    default:
        qWarning() << "HomeWindow::groupSearch(): Invalid service";
        return;
    }
}

void HomeWindow::userSearch(const QString &query, Services::VideoService service) {
    switch (service) {
    case Services::YouTube:
    {
        YouTubeUserListWindow *youtubeWindow = new YouTubeUserListWindow(this);
        youtubeWindow->search(query);
        youtubeWindow->show();
    }
        return;
    case Services::Dailymotion:
    {
        DailymotionUserListWindow *dailymotionWindow = new DailymotionUserListWindow(this);
        dailymotionWindow->search(query);
        dailymotionWindow->show();
    }
        return;
    default:
        qWarning() << "HomeWindow::userSearch(): Invalid service";
        return;
    }
}

void HomeWindow::showPlaybackQueue() {
    PlaybackQueueWindow *window = new PlaybackQueueWindow(this);
    window->show();
}

void HomeWindow::showTransfers() {
    TransferListWindow *window = new TransferListWindow(this);
    window->show();
}

void HomeWindow::showArchive() {
    ArchiveWindow *window = new ArchiveWindow(this);
    window->show();
}

void HomeWindow::showAccounts() {
    AccountsDialog *dialog = new AccountsDialog(this);
    dialog->open();
}

void HomeWindow::showSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("You are not signed in to an account. Would you like to sign in now?"));
    dialog->open();

    this->connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showSocialSignInDialog() {
    QueryDialog *dialog = new QueryDialog(this);
    dialog->setWindowTitle(tr("Sign in?"));
    dialog->setMessage(tr("This feature requires you to be signed in to a facebook or twitter account. Would you like to sign in now?"));
    dialog->open();

    this->connect(dialog, SIGNAL(accepted()), this, SLOT(showAccounts()));
}

void HomeWindow::showLinkGoogleAccountDialog() {
    LinkGoogleAccountDialog *dialog = new LinkGoogleAccountDialog(this);
    dialog->show();
}

void HomeWindow::showFacebookAuthDialog() {
    FacebookAuthDialog *dialog = new FacebookAuthDialog(this);
    dialog->open();
}

void HomeWindow::showTwitterAuthDialog() {
    TwitterAuthDialog *dialog = new TwitterAuthDialog(this);
    dialog->open();
}
