#include "dailymotionvideocommentstab.h"
#include "commentdelegate.h"
#include "dailymotioncommentdialog.h"
#include "dailymotionchannelwindow.h"
#include "../base/dailymotion.h"
#include "windowstack.h"
#include "../base/notifications.h"
#include "../base/dailymotioncommentlistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

DailymotionVideoCommentsTab::DailymotionVideoCommentsTab(QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractTab(parent),
    m_video(video),
    m_model(new DailymotionCommentListModel(this)),
    m_listView(new ListView(this)),
    m_commentAction(new QAction(tr("Add comment"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No comments found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_commentAction);

    m_commentAction->setEnabled(Dailymotion::instance()->userSignedIn());
    m_noResultsLabel->hide();
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);

    CommentDelegate *delegate = new CommentDelegate(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(delegate);
    m_listView->setUniformItemSizes(false);

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreComments()));
    this->connect(delegate, SIGNAL(showUserChannel(QModelIndex)), this, SLOT(showUserChannel(QModelIndex)));
    this->connect(m_commentAction, SIGNAL(triggered()), this, SLOT(showCommentDialog()));

    m_model->getComments(m_video.data()->videoId());

    this->onOrientationChanged();
}

void DailymotionVideoCommentsTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionVideoCommentsTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionVideoCommentsTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void DailymotionVideoCommentsTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void DailymotionVideoCommentsTab::showCommentDialog() {
    DailymotionCommentDialog *dialog = new DailymotionCommentDialog(m_video, this);
    dialog->open();
}

void DailymotionVideoCommentsTab::showUserChannel(const QModelIndex &index) {
    DailymotionChannelWindow *window = new DailymotionChannelWindow(index.data(AbstractCommentListModel::ArtistIdRole).toString(), WindowStack::instance()->currentWindow());
    window->show();
}
