#ifndef DAILYMOTIONPLAYLISTLISTTAB_H
#define DAILYMOTIONPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "../base/playlistitem.h"

class ListView;
class DailymotionPlaylistListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class DailymotionPlaylistListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit DailymotionPlaylistListTab(QWidget *parent = 0);
    void setPlaylistFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);

private:
    ListView *m_listView;
    DailymotionPlaylistListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPLAYLISTLISTTAB_H
