#include "connectionsselector.h"
#include "../base/selectionmodels.h"
#include <QMaemo5ListPickSelector>

ConnectionsSelector::ConnectionsSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new ConnectionsModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    m_selector->setModelColumn(0);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void ConnectionsSelector::setValue(int value) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i).toInt() == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

int ConnectionsSelector::currentValue() {
    return m_model->value(m_selector->currentIndex()).toInt();
}

void ConnectionsSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
