#include "commentdelegate.h"
#include "../base/abstractcommentlistmodel.h"
#include "../base/utils.h"
#include <QApplication>
#include <QMouseEvent>
#include <QPainter>
#include <QMaemo5Style>

CommentDelegate::CommentDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void CommentDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    Utils::drawBorderImage(painter, option.rect, QImage("/etc/hildon/theme/images/ContactsAppletBubble.png"), 60, 30, 30, 30);

    int indent = index.data(AbstractCommentListModel::IndentRole).toInt();
    bool avatarPressed = index.data(AbstractCommentListModel::AvatarPressedRole).toBool();
//    bool loaderPressed = index.data(AbstractCommentListModel::LoaderPressedRole).toBool();

    QRect backgroundRect = option.rect;
    backgroundRect.setLeft(backgroundRect.left() + 24 + (indent * 20));
    backgroundRect.setRight(backgroundRect.right() - 16);
    backgroundRect.setTop(backgroundRect.top() + 16);

    QRect artistRect = backgroundRect;
    artistRect.setLeft(artistRect.left() + 60);
    artistRect.setRight(artistRect.right() - 58);

    QFont newFont;
    newFont.setPixelSize(18);
    painter->setFont(newFont);
    painter->setPen(QMaemo5Style::standardColor("ReversedTextColor"));

    QString artistText = QString("%1 - %2").arg(index.data(AbstractCommentListModel::ArtistRole).toString(), index.data(AbstractCommentListModel::DateRole).toString());

    painter->drawText(artistRect, Qt::AlignTop | Qt::TextWordWrap, artistText);

    painter->restore();

    if ((option.state) & (QStyle::State_Selected) && (avatarPressed)) {
        painter->setOpacity(0.5);
    }

    QImage avatar = index.data(AbstractCommentListModel::ArtistAvatarRole).value<QImage>();

    if (!avatar.isNull()) {
        painter->drawImage(backgroundRect.left(), backgroundRect.top(), avatar);
    }

    painter->drawRect(backgroundRect.left(), backgroundRect.top(), 50, 50);

//    QString id = index.data(AbstractCommentListModel::IdRole).toString();
//    QString replyId = index.data(AbstractCommentListModel::ReplyIdRole).toString();
//
//    if ((!replyId.isEmpty()) && (replyId != id) && (indent == 0)) {
//        if ((option.state) & (QStyle::State_Selected) && (loaderPressed)) {
//            painter->setOpacity(0.5);
//        }
//
//        painter->drawImage(backgroundRect.right() - 43, backgroundRect.top() - 10, QImage("/usr/share/icons/hicolor/48x48/hildon/rss_reader_move_up.png"));
//    }
//
    painter->setOpacity(1);
    painter->save();
    painter->setPen(QMaemo5Style::standardColor("ReversedTextColor"));

    QRect bodyRect = backgroundRect;
    bodyRect.setTop(bodyRect.top() + 55);
    bodyRect.setLeft(bodyRect.left() + 55);

    painter->drawText(bodyRect, Qt::TextWordWrap, index.data(AbstractCommentListModel::BodyRole).toString());
    painter->restore();
}

bool CommentDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index) {
    if (event->type() == QEvent::MouseButtonPress) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        QRect avatarRect = option.rect;
        avatarRect.setLeft(avatarRect.left() + 5 + (index.data(AbstractCommentListModel::IndentRole).toInt() * 20));
        avatarRect.setTop(avatarRect.top() + 5);
        avatarRect.setSize(QSize(50, 50));

        if (avatarRect.contains(mouse->pos())) {
            model->setData(index, index.row(), AbstractCommentListModel::AvatarPressedRole);
        }
//        else if (!index.data(AbstractCommentListModel::LoadingRole).toBool()) {
//            QRect arrowRect = option.rect;
//            arrowRect.setLeft(arrowRect.right() - 53);
//            arrowRect.setSize(QSize(48, 48));
//
//            if (arrowRect.contains(mouse->pos())) {
//                model->setData(index, index.row(), AbstractCommentListModel::LoaderPressedRole);
//           }
//        }

        return true;
    }

    if (event->type() == QEvent::MouseButtonRelease) {
        QMouseEvent *mouse = static_cast<QMouseEvent*>(event);

        if (index.data(AbstractCommentListModel::AvatarPressedRole).toBool()) {
            QRect avatarRect = option.rect;
            avatarRect.setLeft(avatarRect.left() + 5 + (index.data(AbstractCommentListModel::IndentRole).toInt() * 10));
            avatarRect.setTop(avatarRect.top() + 5);
            avatarRect.setSize(QSize(50, 50));

            if (avatarRect.contains(mouse->pos())) {
                emit showUserChannel(index);
            }
        }
//        else if ((index.data(AbstractCommentListModel::LoaderPressedRole).toBool()) && (!index.data(AbstractCommentListModel::LoadingRole).toBool())) {
//            QRect arrowRect = option.rect;
//            arrowRect.setLeft(arrowRect.right() - 48);
//            arrowRect.setSize(QSize(48, 48));
//
//            if (arrowRect.contains(mouse->pos())) {
//                emit getInitialComment(index.row());
//            }
//        }

        model->setData(index, -1, AbstractCommentListModel::AvatarPressedRole);
//        model->setData(index, -1, AbstractCommentListModel::LoaderPressedRole);

        return true;
    }

    return false;
}

QSize CommentDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    return QSize(option.rect.width(), option.fontMetrics.boundingRect(option.rect, Qt::TextWordWrap, index.data(AbstractCommentListModel::BodyRole).toString()).height() + 100);
}
