#ifndef YOUTUBECATEGORYMODEL_H
#define YOUTUBECATEGORYMODEL_H

#include "enums.h"
#include "selectionmodels.h"

class YouTubeCategoryModel : public SelectionModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    explicit YouTubeCategoryModel(QObject *parent = 0);

private:
    QString feedFromValues(const QString &value, bool standard = false, Queries::TimeFilter time = Queries::None);

signals:
    void countChanged(int count);

private:
    QHash<int, QString> m_time_filters;
};

#endif // YOUTUBECATEGORYMODEL_H
