#include "vimeogrouplistmodel.h"
#include "feedurls.h"
#include "vimeo.h"
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QTimer>

VimeoGroupListModel::VimeoGroupListModel(QObject *parent) :
    AbstractGroupListModel(parent),
    m_loading(true),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void VimeoGroupListModel::clear() {
    AbstractGroupListModel::clear();
    this->setLoading(false);
    this->setOffset(1);
    this->setMoreResults(true);
    this->setError(false);
}

void VimeoGroupListModel::reset() {
    if (!this->loading()) {
        this->clear();
        this->getMoreGroups();
    }
}

void VimeoGroupListModel::setFeed(const QUrl &feed) {
    if (feed != this->feed()) {
        m_feed = feed;
    }
}

void VimeoGroupListModel::getGroups(QUrl feed) {
    if (!feed.isEmpty()) {
        this->setFeed(feed);
    }

    this->setLoading(true);
    QNetworkReply *reply = Vimeo::instance()->createReply(this->feed(), this->offset());
    reply->setParent(this);
    this->connect(reply, SIGNAL(finished()), this, SLOT(addGroups()));
}

void VimeoGroupListModel::addGroups() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        this->setLoading(false);
        this->setError(true);
        return;
    }

    QDomDocument doc;
    doc.setContent(reply->readAll());
    QDomElement responseNode = doc.firstChildElement("rsp");

    if (responseNode.attribute("stat") == "ok") {
        QDomNodeList entries = doc.elementsByTagName("group");

        for (int i = 0; i < entries.size(); i++) {
            GroupItem *group = new GroupItem;
            group->loadVimeoGroup(entries.at(i).toElement());
            QMetaObject::invokeMethod(this, "appendGroup", Qt::QueuedConnection, Q_ARG(QSharedPointer<GroupItem>, QSharedPointer<GroupItem>(group)));
        }

        QDomElement statNode = responseNode.firstChildElement("groups");

        QTimer::singleShot(1000, this, SLOT(stopLoading()));
        this->setMoreResults(statNode.attribute("total").toInt() > this->rowCount());
        this->setOffset(statNode.attribute("page").toInt() + 1);

        emit countChanged(this->rowCount());
    }
    else {
        this->setLoading(false);
        this->setError(true);
    }

    reply->deleteLater();
}

void VimeoGroupListModel::getMoreGroups() {
    if ((this->moreResults()) && (!this->loading())) {
        this->getGroups();
    }
}
