#include "youtubeuserlisttab.h"
#include "youtubeuserlistdelegate.h"
#include "youtubevideolistwindow.h"
#include "youtubechannelwindow.h"
#include "../base/youtubeuserlistmodel.h"
#include "listview.h"
#include "windowstack.h"
#include "../base/notifications.h"
#include <QLabel>
#include <QGridLayout>
#include <QAction>
#include <QMaemo5Style>

YouTubeUserListTab::YouTubeUserListTab(const QString &userId, QWidget *parent) :
    AbstractTab(parent),
    m_userId(userId),
    m_model(new YouTubeUserListModel(this)),
    m_listView(new ListView(this)),
    m_videosAction(new QAction(tr("Latest videos"), this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No subscriptions found")), this)),
    m_grid(new QGridLayout(this))
{
    this->addAction(m_videosAction);

    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubeUserListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreUsers()));
    this->connect(m_videosAction, SIGNAL(triggered()), this, SLOT(showSubscriptionVideos()));

    this->onOrientationChanged();
}

void YouTubeUserListTab::setFeed(const QUrl &feed) {
    m_model->getUsers(feed);
}

void YouTubeUserListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubeUserListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubeUserListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void YouTubeUserListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void YouTubeUserListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showUserChannel(index.data(AbstractUserListModel::IdRole).toString());
    }
}

void YouTubeUserListTab::showUserChannel(const QString &userId) {
    YouTubeChannelWindow *window = new YouTubeChannelWindow(userId, WindowStack::instance()->currentWindow());
    window->show();
}

void YouTubeUserListTab::showSubscriptionVideos() {
    YouTubeVideoListWindow *window = new YouTubeVideoListWindow(WindowStack::instance()->currentWindow());
    window->setVideoFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/newsubscriptionvideos?v=2.1&max-results=30").arg(m_userId));
}
