#ifndef DAILYMOTIONNEWPLAYLISTDIALOG_H
#define DAILYMOTIONNEWPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class QScrollArea;
class QLineEdit;
class QTextEdit;
class QDialogButtonBox;
class QPushButton;
class QGridLayout;

class DailymotionNewPlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionNewPlaylistDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void createPlaylist();

signals:
    void playlistCreated(const QVariantMap &playlist);

private:
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONNEWPLAYLISTDIALOG_H
