#ifndef DAILYMOTIONMETADATADIALOG_H
#define DAILYMOTIONMETADATADIALOG_H

#include "abstractdialog.h"
#include "../base/videoitem.h"

class DailymotionUploadCategorySelector;
class QLineEdit;
class QTextEdit;
class QPushButton;
class QCheckBox;
class QDialogButtonBox;
class QScrollArea;
class QGridLayout;

class DailymotionMetadataDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionMetadataDialog(QSharedPointer<VideoItem> video, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void setMetadata(const QVariantMap &metadata);
    void submitMetadata();

private:
    QSharedPointer<VideoItem> m_video;
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QLineEdit *m_tagsEdit;
    DailymotionUploadCategorySelector *m_categorySelector;
    QCheckBox *m_commentsCheckbox;
    QCheckBox *m_privateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONMETADATADIALOG_H
