#include "dailymotioncategorymodel.h"
#include "feedurls.h"

DailymotionCategoryModel::DailymotionCategoryModel(QObject *parent) :
    SelectionModel(parent)
{
    this->addItem(tr("Animals"), this->feedFromValue("animals"));
    this->addItem(tr("Arts"), this->feedFromValue("arts"));
    this->addItem(tr("Auto-Moto"), this->feedFromValue("auto"));
    this->addItem(tr("Film & TV"), this->feedFromValue("shortfilms"));
    this->addItem(tr("Funny"), this->feedFromValue("fun"));
    this->addItem(tr("Gaming"), this->feedFromValue("videogames"));
    this->addItem(tr("Gay & Lesbian"), this->feedFromValue("gaylesbian"));
    this->addItem(tr("Kids"), this->feedFromValue("kids"));
    this->addItem(tr("Life & Style"), this->feedFromValue("lifestyle"));
    this->addItem(tr("Most Recent"), this->feedFromValue("most_recent"));
    this->addItem(tr("Most Viewed"), this->feedFromValue("most_viewed"));
    this->addItem(tr("Music"), this->feedFromValue("music"));
    this->addItem(tr("News & Politics"), this->feedFromValue("news"));
    this->addItem(tr("People & Family"), this->feedFromValue("people"));
    this->addItem(tr("Sexy"), this->feedFromValue("sexy"));
    this->addItem(tr("Sports & Extreme"), this->feedFromValue("sport"));
    this->addItem(tr("Tech & Science"), this->feedFromValue("tech"));
    this->addItem(tr("Travel"), this->feedFromValue("travel"));
    this->addItem(tr("Webcam & Vlogs"), this->feedFromValue("webcam"));
    emit countChanged(this->rowCount());
}

QString DailymotionCategoryModel::feedFromValue(const QString &value) {
    QString feed(DAILYMOTION_VIDEOS_BASE_URL);

    if (value == "most_recent") {
        feed.append("?sort=recent&limit=30");
    }
    else if (value == "most_viewed") {
        feed.append("?sort=visited&limit=30");
    }
    else {
        feed.append(QString("?sort=recent&limit=30&channel=%1").arg(value));
    }

    return feed;
}
