#include "vimeoauthdialog.h"
#include "../base/vimeo.h"
#include "../base/notifications.h"
#include "webview.h"
#include <QProgressBar>
#include <QGridLayout>

VimeoAuthDialog::VimeoAuthDialog(const QString &accountName, QWidget *parent) :
    AbstractDialog(parent),
    m_name(accountName),
    m_webView(new WebView(this)),
    m_progressBar(new QProgressBar(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Vimeo authorisation"));

    m_grid->addWidget(m_webView, 0, 0);
    m_grid->addWidget(m_progressBar, 1, 0);

    m_webView->enableSelectionSuppressor();
    m_progressBar->setTextVisible(false);

    this->connect(Vimeo::instance(), SIGNAL(gotAuthUrl(QUrl)), this, SLOT(setAuthUrl(QUrl)));
    this->connect(m_webView, SIGNAL(loadProgress(int)), m_progressBar, SLOT(setValue(int)));
    this->connect(m_webView, SIGNAL(loadStarted()), m_progressBar, SLOT(show()));
    this->connect(m_webView, SIGNAL(loadFinished(bool)), m_progressBar, SLOT(hide()));

    Vimeo::instance()->getAuthUrl();

    this->onOrientationChanged();
}

void VimeoAuthDialog::setAuthUrl(const QUrl &url) {
    m_authUrl = url;
    m_webView->setUrl(url);
    this->connect(m_webView, SIGNAL(urlChanged(QUrl)), this, SLOT(checkUrlForToken(QUrl)));
}

void VimeoAuthDialog::checkUrlForToken(const QUrl &url) {
    if (url.toString() == "https://vimeo.com/home") {
        //Work-around as for some reason Vimeo bounces you back to the homepage on the first attempt.
        m_webView->setUrl(m_authUrl);
    }
    if (url.toString().startsWith("https://sites.google.com/site/marxodian/home/cutetube")) {
        Vimeo::instance()->signIn(m_name, url);
        this->accept();
    }
    else if (url.toString() == "https://vimeo.com") {
        Notifications::showInfo(tr("You have denied access to your Vimeo account"));
        this->reject();
    }
}
