#include "playbackqualitydialog.h"
#include "separatorlabel.h"
#include "../base/settings.h"
#include <QCheckBox>
#include <QGridLayout>
#include <QDialogButtonBox>
#include <QScrollArea>

PlaybackFormatDialog::PlaybackFormatDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_youtube720Checkbox(new QCheckBox("720P AVC1", this)),
    m_youtube480Checkbox(new QCheckBox("480P FLV", this)),
    m_youtube360Checkbox(new QCheckBox("360P FLV", this)),
    m_youtubeNormalCheckbox(new QCheckBox(tr("Normal") + " AVC1", this)),
    m_youtube240Checkbox(new QCheckBox("240P AVC1", this)),
    m_youtube144Checkbox(new QCheckBox("144P AVC1", this)),
    m_dailymotion720Checkbox(new QCheckBox("720P AVC1", this)),
    m_dailymotion480Checkbox(new QCheckBox("480P AVC1", this)),
    m_dailymotion384Checkbox(new QCheckBox("384P AVC1", this)),
    m_dailymotion240Checkbox(new QCheckBox("240P AVC1", this)),
    m_vimeo720Checkbox(new QCheckBox("720P AVC1", this)),
    m_vimeo360Checkbox(new QCheckBox("360P AVC1", this)),
    m_vimeoMobileCheckbox(new QCheckBox(tr("Mobile"), this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Save, Qt::Vertical, this)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Playback quality"));
    this->setAttribute(Qt::WA_DeleteOnClose, false);

    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(new SeparatorLabel("YouTube", this));
    vbox->addWidget(m_youtube720Checkbox);
    vbox->addWidget(m_youtube480Checkbox);
    vbox->addWidget(m_youtube360Checkbox);
    vbox->addWidget(m_youtubeNormalCheckbox);
    vbox->addWidget(m_youtube240Checkbox);
    vbox->addWidget(m_youtube144Checkbox);
    vbox->addWidget(new SeparatorLabel("Dailymotion", this));
    vbox->addWidget(m_dailymotion720Checkbox);
    vbox->addWidget(m_dailymotion480Checkbox);
    vbox->addWidget(m_dailymotion384Checkbox);
    vbox->addWidget(m_dailymotion240Checkbox);
    vbox->addWidget(new SeparatorLabel("Vimeo", this));
    vbox->addWidget(m_vimeo720Checkbox);
    vbox->addWidget(m_vimeo360Checkbox);
    vbox->addWidget(m_vimeoMobileCheckbox);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    this->loadSettings();
    this->onOrientationChanged();
}

void PlaybackFormatDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void PlaybackFormatDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void PlaybackFormatDialog::loadSettings() {
    m_youtube720Checkbox->setChecked(Settings::instance()->enableYouTube720Playback());
    m_youtube480Checkbox->setChecked(Settings::instance()->enableYouTube480Playback());
    m_youtube360Checkbox->setChecked(Settings::instance()->enableYouTube360Playback());
    m_youtubeNormalCheckbox->setChecked(Settings::instance()->enableYouTubeNormalPlayback());
    m_youtube240Checkbox->setChecked(Settings::instance()->enableYouTube240Playback());
    m_youtube144Checkbox->setChecked(true);
    m_youtube144Checkbox->setEnabled(false);
    m_dailymotion720Checkbox->setChecked(Settings::instance()->enableDailymotion720Playback());
    m_dailymotion480Checkbox->setChecked(Settings::instance()->enableDailymotion480Playback());
    m_dailymotion384Checkbox->setChecked(Settings::instance()->enableDailymotion384Playback());
    m_dailymotion240Checkbox->setChecked(true);
    m_dailymotion240Checkbox->setEnabled(false);
    m_vimeo720Checkbox->setChecked(Settings::instance()->enableVimeo720Playback());
    m_vimeo360Checkbox->setChecked(Settings::instance()->enableVimeo360Playback());
    m_vimeoMobileCheckbox->setChecked(true);
    m_vimeoMobileCheckbox->setEnabled(false);
}

void PlaybackFormatDialog::saveSettings() {
    Settings::instance()->setEnableYouTube720Playback(m_youtube720Checkbox->isChecked());
    Settings::instance()->setEnableYouTube480Playback(m_youtube480Checkbox->isChecked());
    Settings::instance()->setEnableYouTube360Playback(m_youtube360Checkbox->isChecked());
    Settings::instance()->setEnableYouTubeNormalPlayback(m_youtubeNormalCheckbox->isChecked());
    Settings::instance()->setEnableYouTube240Playback(m_youtube240Checkbox->isChecked());
    Settings::instance()->setEnableDailymotion720Playback(m_dailymotion720Checkbox->isChecked());
    Settings::instance()->setEnableDailymotion480Playback(m_dailymotion480Checkbox->isChecked());
    Settings::instance()->setEnableDailymotion384Playback(m_dailymotion384Checkbox->isChecked());
    Settings::instance()->setEnableVimeo720Playback(m_vimeo720Checkbox->isChecked());
    Settings::instance()->setEnableVimeo360Playback(m_vimeo360Checkbox->isChecked());

    this->accept();
}
