#ifndef DAILYMOTIONPLAYLISTDIALOG_H
#define DAILYMOTIONPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class DailymotionUserPlaylistListModel;
class ListView;
class QDialogButtonBox;
class QPushButton;
class QLabel;
class QGridLayout;
class QModelIndex;

class DailymotionPlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit DailymotionPlaylistDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void showNewPlaylistDialog();
    void onItemClicked(const QModelIndex &index);
    void onPlaylistsLoaded();

signals:
    void playlistChosen(const QString &id);
    void addToNewPlaylist(const QVariantMap &playlist);

private:
    DailymotionUserPlaylistListModel *m_model;
    ListView *m_listView;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_newButton;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONPLAYLISTDIALOG_H
