#include "searchlistmodel.h"
#include "settings.h"
#include <QStringListModel>
#include <QStringList>

SearchListModel::SearchListModel(QObject *parent) :
    QSortFilterProxyModel(parent),
    m_model(new QStringListModel(this))
  #if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
    ,m_highlight(Settings::instance()->activeColor())
  #endif
{
    this->setSourceModel(m_model);
    this->setFilterRole(Qt::DisplayRole);
    this->setDynamicSortFilter(true);
    this->setSearches(Settings::instance()->value("Search/recentSearches", QStringList()).toStringList());
}

SearchListModel::~SearchListModel() {}

void SearchListModel::saveSearches() {
    QStringList strings;
    int i = 0;

    while ((i < 50) && (i < m_model->stringList().size())) {
        strings << m_model->stringList().at(i);
        i++;
    }

    Settings::instance()->setValue("Search/recentSearches", strings);
}

void SearchListModel::setSearches(const QStringList &searches) {
    m_model->setStringList(searches);
}

void SearchListModel::setQuery(const QString &query) {
    if (query != this->query()) {
        m_query = query;
        this->setFilterRegExp(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));
        emit dataChanged(this->index(0, 0), this->index(this->rowCount() - 1, 0));
        emit queryChanged(query);
    }
}

QString SearchListModel::regexMatch(QString str) const {
    QRegExp re(this->filterRegExp());

    if ((!re.isEmpty()) && (re.indexIn(str) > -1)) {
#if (defined (QML_USER_INTERFACE) && (!defined (Q_WS_MAEMO_5)))
        str.replace(re, "<u><font color=\"" + this->highlightColor() + "\">" + re.cap() + "</font></u>");
#else
        str.replace(re, "<b>" + re.cap() + "</b>");
#endif
    }

    return str;
}

void SearchListModel::addSearch(const QString &query) {
    int i = m_model->stringList().indexOf(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));

    if (i >= 0) {
        m_model->removeRow(i);
    }

    m_model->insertRow(0);
    m_model->setData(m_model->index(0), query, 0);
    this->saveSearches();
    emit countChanged(this->rowCount());
}

void SearchListModel::removeSearch(int row) {
    m_model->removeRow(row);
    this->saveSearches();
    emit countChanged(this->rowCount());
}

void SearchListModel::clearSearches() {
    this->beginResetModel();
    m_model->setStringList(QStringList());
    this->endResetModel();
    this->saveSearches();
    emit countChanged(this->rowCount());
    emit alert(tr("Search history cleared"));
}

QVariant SearchListModel::data(const QModelIndex &index, int role) const {
#ifdef QML_USER_INTERFACE
    return m_model->data(this->mapToSource(index), role);
#else
    return this->query().isEmpty() ? m_model->data(this->mapToSource(index), role) : this->regexMatch(m_model->data(this->mapToSource(index), role).toString());
#endif
}

QVariant SearchListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row, 0), this->roleNames().key(role));
}
