#ifndef CURRENCY_WIDGET_H
#define CURRENCY_WIDGET_H

#include <glib-object.h>
#include <stdio.h>
#include <time.h>
#include <libhildondesktop/libhildondesktop.h>
#include <gconf/gconf-client.h>
#include <libosso.h>
#include <pthread.h>

G_BEGIN_DECLS


#define CURRENCY_WIDGET_TYPE_HOME_PLUGIN   (currency_widget_plugin_get_type ())

#define CURRENCY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                                CURRENCY_WIDGET_TYPE_HOME_PLUGIN, CurrencyWidget))

#define CURRENCY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                                                CURRENCY_WIDGET_TYPE_HOME_PLUGIN,  CurrencyWidgetHomePluginClass))

#define CURRENCY_WIDGET_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                                CURRENCY_WIDGET_TYPE_HOME_PLUGIN))
 
#define CURRENCY_WIDGET_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                                                CURRENCY_WIDGET_TYPE_HOME_PLUGIN))

#define CURRENCY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                                                CURRENCY_WIDGET_TYPE_HOME_PLUGIN,  CurrencyWidgetHomePluginClass))


#define SERVER "http://xurrency.com/api/"
//#define SERVER "http://www.google.com/"
//#define PORT "81"
#define BUFFER_SIZE (256*1024)


#define BACKGROUND_ICON "/usr/share/currency-exchange-widget/icons/bg.png"

#define GCONF_KEY_PREFIX "/apps/maemo/currency-exchange-widget/"

#define GCONF_KEY_CURRENCY_FROM GCONF_KEY_PREFIX"from"
#define GCONF_KEY_CURRENCY_TO GCONF_KEY_PREFIX"to"
#define GCONF_KEY_CURRENCY_VALUE GCONF_KEY_PREFIX"value"
#define GCONF_KEY_CURRENCY_UPDATE_INTERVAL GCONF_KEY_PREFIX"update-interval"
#define GCONF_KEY_CURRENCY_LAST_UPDATE GCONF_KEY_PREFIX"last-update"

#define OSSO_NAME "currency_exchange_widget"
#define OSSO_SERVICE "org.maemo."OSSO_NAME
#define OSSO_OBJECT  "/org/maemo/"OSSO_NAME
#define OSSO_IFACE   "org.maemo."OSSO_NAME

#define ICONS_DIR "/usr/share/currency-exchange-widget/icons/"
#define BINOP_ICON "/usr/share/currency-exchange-widget/icons/binop.png"
#define GTK_RESPONSE_ABOUT 12

#define TO_HOUR(x) ((x) * 60 * 60 * 1000)
#define TIMEOUT 5



enum Currency {
        EUR  = 1, USD, GBP, AUD, BRL, CAD, CHF, CNY, DKK, HKD, INR, JPY, LKR, MYR, NZD, SGD, TWD, ZAR, VEB, THB, SEK, NOK, MXN, BGN, CZK, EEK, HUF, LTL, LVL, PLN, RON, SKK, ISK, HRK, RUB, TRY, PHP, COP, ARS, CLP, SVC, TND, PYG, MAD, JMD, SAR, OAR, HNL
};

/* Currency structures */
typedef struct {
        char *name;
        char *value;
        char *icon;
        enum Currency type;
} currency;

// TODO: change this to currency
typedef struct {
        char *name;
        enum Currency type; 
        
        currency *active_currency;
        int update_interval;
        time_t last_update;
        int not_updated;
        int currency_changed;
} currency_set;




/* Widget Structures */
typedef struct _CurrencyWidget CurrencyWidget;
typedef struct _CurrencyWidgetClass CurrencyWidgetClass;


struct _CurrencyWidget
{
            HDHomePluginItem hitem;
            // Add struct for information
            GtkLabel *info_label;
            GtkWidget *curr_flag;
            GtkVBox *contents;

            GtkHBox *main_box;
            GtkWidget *main_event_box;

            GtkHBox *curr_box;
           
            // Currency set for plugin
            currency_set *curset;

            
            gchar *id;
            int timeout;
            pthread_mutex_t mutex;
};
 
struct _CurrencyWidgetClass
{
            HDHomePluginItemClass parent_class;
};
 
typedef struct  _SignalData SignalData;

struct _SignalData { 
    int currency_type;
    osso_context_t *osso_context;
};

GType currency_widget_plugin_get_type(void);

G_END_DECLS

#endif
