#include "remainingtrialitem.h"
#include <QPainter>

RemainingTrialItem::RemainingTrialItem( int totalAvailableTrial )
    :QGraphicsItem(0), mTotalAvailableTrial(totalAvailableTrial),mPixmap(":/image/trial_egg.png")
{
}

void RemainingTrialItem::setRemainigTrial( int remainingTrial)
{
    mTotalAvailableTrial = remainingTrial;
}

int RemainingTrialItem::remainingTrial() const
{
    return mTotalAvailableTrial;
}

void RemainingTrialItem::decreaseTrial()
{
    mTotalAvailableTrial --;
    update();
}

bool RemainingTrialItem::isTrialAvailable() const
{
    return ( mTotalAvailableTrial > 0 );
}

void RemainingTrialItem::paint ( QPainter * painter, const QStyleOptionGraphicsItem * /*option*/, QWidget * /*widget*/ )
{
    int x = 0;
    for(int i = 0; i < mTotalAvailableTrial; ++i ) {
        painter->drawPixmap(x,0,30,40,mPixmap);
        x += 33;
    }
}

QRectF RemainingTrialItem::boundingRect() const
{
    return QRectF(0,0,33*4,40);
}
