#ifndef MICKYMOUSE_H
#define MICKYMOUSE_H

#include <QGraphicsItem>
#include <QPixmap>
#include <QList>
#include "common.h"

class Egg;

class MickyMouse : public QGraphicsItem
{
public:

    explicit MickyMouse();

    void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );

    QRectF boundingRect() const;

    void catchEgg( Position pos);

    int position() const;

    bool isFallingInBasket( Egg* egg );

private:

    QList<QPixmap> mMickyMouse;
    int mCurrentPos;

};

#endif // MICKYMOUSE_H
