#ifndef ABSCRACTSCREEN_H
#define ABSCRACTSCREEN_H

#include <QGraphicsObject>

class TextButton;
class RoundRectButton;
class QGraphicsTextItem;

class AbscractScreen : public QGraphicsObject
{    
public:
    AbscractScreen(QGraphicsScene* scene);

    virtual void paint ( QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0 );

    virtual QRectF boundingRect() const;

protected:

    TextButton* createTextButton( const QString& buttonText, int fontSize);

    RoundRectButton* createRoundRectButton( const QString& buttonText, int fontSize,int buttonWidth);

    QGraphicsTextItem* createTextItem(int fontSize, bool bold = false);
};

#endif // ABSCRACTSCREEN_H
