#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Librarys
###########################################################################################
import sys, dbus, gtk, hildon, gobject
from HeAboutDialog import HeAboutDialog

#Files
###########################################################################################
from Config import Config
from Notifications import Notifications

#Classes
###########################################################################################
class MainDialog(gtk.Dialog):
	def __init__(self):
		self.bus = dbus.bus.BusConnection("unix:path=/var/run/dbus/system_bus_socket")
		#Classes
		self.Config = Config(self)
		self.Notifications = Notifications(self)
		#Get configuration
		self.networks = self.Config.getAllNetworks()
		self.timeouts = [[1000, 'Disabled'],[5, 'After 5 minutes'],[10, 'After 10 minutes'],[30, 'After 30 minutes'],[60, 'After 1 hour']]
		self.timeout = self.Config.getTimeout()
		self.instantLockOnDisconnect = self.Config.getInstantLockOnDisconnect()
		self.instantLockOnDetach = self.Config.getInstantLockOnDetach()
		self.notifications = self.Config.getNotifications()
		#Create window
		super(MainDialog, self).__init__()
		self.connect('delete_event', self.quit)
		self.set_title('ConnLock settings')
		#Buttons
		help = self.add_button(gtk.STOCK_HELP, gtk.RESPONSE_NONE)
		help.connect('clicked', self.help)
		about = self.add_button('About', gtk.RESPONSE_NONE)
		about.connect('clicked', self.about)
		save = self.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
		save.connect('clicked', self.save)
		timeoutSelector = self.createTimeoutSelector()
		selectTimeout = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_HORIZONTAL)
		selectTimeout.set_alignment(0,0,1,1)
		selectTimeout.set_title('Autolock')
		selectTimeout.set_selector(timeoutSelector)
		networkSelector = self.createNetworkSelector()
		selectNetworks = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		selectNetworks.set_alignment(0,0,1,1)
		selectNetworks.set_title('Select trusted networks')
		selectNetworks.set_selector(networkSelector)
		disconnect = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		disconnect.connect('toggled', self.toggleDisconnect)
		if self.instantLockOnDisconnect:
			disconnect.set_active(True)
		disconnect.set_label('Lock instantly when disconnected')
		charger = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		charger.connect('toggled', self.toggleDetach)
		if self.instantLockOnDetach:
			charger.set_active(True)
		charger.set_label('Lock when detached from charger')
		notifications = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
		notifications.connect('toggled', self.toggleNotifications)
		if self.notifications:
			notifications.set_active(True)
		notifications.set_label('Show notifications')
		self.vbox.pack_start(selectTimeout, False, False, 0)
		self.vbox.pack_start(selectNetworks, False, False, 0)
		self.vbox.pack_start(disconnect, False, False, 0)
		self.vbox.pack_start(charger, False, False, 0)
		self.vbox.pack_start(notifications, False, False, 0)
		#Draw
		self.show_all()
		gtk.main()

	def toggleDisconnect(self, widget):
		self.instantLockOnDisconnect = widget.get_active()

	def toggleDetach(self, widget):
		self.instantLockOnDetach = widget.get_active()

	def toggleNotifications(self, widget):
		self.notifications = widget.get_active()

	def createNetworkSelector(self):
		selector = hildon.TouchSelector(text = True)
		
		for network in self.networks:
			selector.append_text(network[1])
		selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)
		selector.unselect_all(0)
		for key, network in enumerate(self.networks):
			if network[2]:
				selector.select_iter(0, selector.get_model(0).get_iter(key), False)
		selector.connect('changed', self.networksChanged)
		return selector

	def createTimeoutSelector(self):
		selector = hildon.TouchSelector(text = True)
		for timeout in self.timeouts:
			selector.append_text(timeout[1])

		selector.unselect_all(0)
		for key, timeout in enumerate(self.timeouts):
			if self.timeout == timeout[0]:
				selector.select_iter(0, selector.get_model(0).get_iter(key), False)
		selector.connect('changed', self.timeoutChanged)
		return selector

	def networksChanged(self, selector, ignore):
		selected = []
		networks = []
		for key, value in enumerate(selector.get_selected_rows(0)):
			selected.append(value[0])
		for key, network in enumerate(self.networks):
			if key in selected:
				networks.append([network[0], network[1], True])
			else:
				networks.append([network[0], network[1], False])
		self.networks = networks

	def timeoutChanged(self, selector, ignore):
		self.timeout = self.timeouts[selector.get_active(0)][0]
	
	def quit(self, ignore1, ignore2):
		gtk.main_quit()

	def save(self, ignore):
		self.Config.setTrustedNetworks(self.networks)
		self.Config.setTimeout(self.timeout)
		self.Config.setInstantLockOnDisconnect(self.instantLockOnDisconnect)
		self.Config.setInstantLockOnDetach(self.instantLockOnDetach)
		self.Config.setNotifications(self.notifications)
		if self.notifications:
			self.Notifications.notify('Settings saved successfully')
		gtk.main_quit()

	def about(self, ignore):
		about = HeAboutDialog(self)
		about.set_app_name('ConnLock')
		about.set_copyright('(c) 2011 Olli Laasonen')
		about.set_bugtracker('mailto:admin@laasonen.net?subject=ConnLock '+self.Config.version+' Bug Report')
		about.set_donate_url('http://donate.laasonen.net/ConnLock')
		about.set_website('http://talk.maemo.org/showthread.php?t=71970')
		about.set_description('Connection based automatic device lock.')
		about.set_version(self.Config.version)
		about.set_icon_name('general_locked')
		about.show_all()

	def help(self, ignore):
		dialog = gtk.Dialog('Help')
		dialog.set_geometry_hints(min_height=800)
		panArea = hildon.PannableArea()
		panArea.set_property('mov-mode', hildon.MOVEMENT_MODE_VERT)
		text = gtk.Label()
		text.set_line_wrap(True)
		text.set_markup('<b>Description</b>\nThis application lets you disable automatic lock when you are connected to network you trust. It also has functionality to automaticly lock your device when the charger is deattached or when your phone gets disconnected from network you trust.\n\n<b>Usage</b>\n1. Select networks you trust.\n2. Your phone will automaticly unlock when you connect to network you trust and it wont lock automaticly while you are connected to network you trust.')
		panArea.add_with_viewport(text)
		dialog.vbox.add(panArea)
		dialog.show_all()

#Run
###########################################################################################
if __name__ == '__main__':
	MainDialog()
