#!/usr/bin/env python
# -*- coding: utf-8 -*-

#Libraries
######################################################
import gconf

#Classes
######################################################
class GconfEditor:
	def __init__(self, dir):
		self.dir = dir
		self.client = gconf.client_get_default()
		if not self.client.dir_exists(self.dir):
			self.client.add_dir(self.dir, gconf.CLIENT_PRELOAD_NONE)

	def set(self, key, value):
		location = self.dir+"/"+key
		if type(value).__name__ == "str": #Set string
			return self.client.set_string(location, value)
		elif type(value).__name__ == "int": #Set int
			return self.client.set_int(location, value)
		elif type(value).__name__ == "bool": #Set bool
			return self.client.set_bool(location, value)
		else: #Unkownn type
			return False

	def get(self, key):
		try:
			return self.client.get_value(self.dir+"/"+key)
		except:
			pass

	def entries(self, subdir=""):
		entries = {}
		for entry in self.client.all_entries(self.dir+""+subdir):
			if entry.get_value().type == gconf.VALUE_STRING:
				value = entry.get_value().get_string()
			elif entry.get_value().type == gconf.VALUE_INT:
				value = entry.get_value().get_int()
			elif entry.get_value().type == gconf.VALUE_BOOL:
				value = entry.get_value().get_bool()
			else:
				continue
			key = entry.get_key().split("/")
			entries[key[len(key)-1]] = value
		return entries

	def directories(self, subdir=""):
		return self.client.all_dirs(self.dir+""+subdir)
