#!/bin/sh

killappman () {
killall hildon-application-manager > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker.real > \/tmp\/output.txt 2> \/dev\/null
}


clean () { 
apt-get clean | zenity --progress --pulsate --title="Clean" --text="Aspetta il caricamento della barra"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Clean Effettuato"
}

autoclean () { 
apt-get autoclean | zenity --progress --pulsate --title="Autoclean" --text="Aspetta il caricamento della barra"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoclean Effettuato"
}

autoremove () {
apt-get autoremove | zenity --progress --pulsate --title="Autoremove" --text="Aspetta il caricamento della barra"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoremove Effettuato"
}

purge () {
apt-get purge | zenity --title="Output Purge" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Purge Effettuato"
}

connessione () {
dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
	sleep 9
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connessione in corso... Attendere prego..."
}

update () {
apt-get update | zenity --title="Output Update" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completato" 
}

popup_ann () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione annullata"
}

aggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Aggiornamenti eseguiti"
}

noaggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Aggiornamenti non eseguiti!"
}

riavvio () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
	org.freedesktop.Notifications.SystemNoteInfoprint string:"Riavvio in corso... Attendere prego..."
		reboot
}

backupcreato () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Backup creato!"
}

opincorso () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione in corso... Attendere prego..."
}

ripristino () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Ripristino effettuato"
}

paccinst () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Pacchetto Installato"
}

paccdis () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Pacchetto Disinstallato"
}

applicazioni () {
zenity --title=CleanN900 --height 250 --list  --text "Seleziona le operazioni che ti interessano" --column "Opzioni" "Crea backup delle tue applicazioni" "Ripristina applicazioni da backup" "Installa un pacchetto" "Rimuovi pacchetto specifico" "Reboot"
}

gestoreaperto () {
zenity --warning --title CleaN900 --text "Hai il gestore applicazioni aperto! Per chiuderlo scegli Ok, altrimenti tappa nel vuoto"
}

primostep () {
zenity --title=CleanN900 --height 350 --list  --text "Seleziona le operazioni che ti interessano" --column "Opzioni" "clean" "autoclean" "autoremove" "purge" "Update" "Upgrade" "Applicazioni" "Reboot"
}

ricconn () {
zenity --warning --title CleaN900 --text "Occorre avere la connessione attiva, meglio se wifi. Se vuoi connetterti scegli Ok, altrimenti tappa nel vuoto"
}

selbackup () {
zenity --title CleaN900 --file-selection --text='Seleziona il file' --filename=/home/user/MyDocs/clean900/ --file-filter "*.txt"
}

seldeb () {
zenity --title CleaN900 --file-selection --text='Seleziona il deb' --filename=/home/user/MyDocs/ --file-filter "*.deb"
}

rempac () {
zenity --entry --title='Rimuovi' --text='Inserisci il nome del pacchetto'
}

waitdis () {
zenity --progress --pulsate --title="Disinstallazione" --text="Aspetta il caricamento della barra"
}
