#!/bin/ash
#Clean900
#version 1.1.2
#by incrys for www.maemomeego.net

if [ `id -u` != 0 ] ; then
    exec root <<EOF
exec sh $0 $*
EOF
	exit $?
fi 


gest=`ps ux |grep -c hildon-application-manager`

if [ $gest = 3 ]
	then
		quest=$(zenity --warning --title CleaN900 --text "Hai il gestore applicazioni aperto! Per chiuderlo scegli Ok, altrimenti tappa nel vuoto";echo $?)

	else
		quest=0
fi



if [ $quest -eq 0 ]
		then
			killall hildon-application-manager > \/tmp\/output.txt 2> \/dev\/null
			killall apt-worker > \/tmp\/output.txt 2> \/dev\/null
			killall apt-worker.real > \/tmp\/output.txt 2> \/dev\/null
	inputline=$(zenity --title=CleanN900 --height 350 --list  --text "Seleziona le operazioni che ti interessano" --column "Opzioni" \
		"clean" "autoclean" "autoremove" "purge" "Update" "Upgrade" "Installa un pacchetto" "Rimuovi pacchetto specifico" "Reboot" \
	--separator=":")

IFS=":"
for prova in $inputline; do
case $prova in

	"clean")apt-get clean | zenity --progress --pulsate --title="Clean" --text="Aspetta il caricamento della barra"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Clean Effettuato";;

	"autoclean")apt-get autoclean | zenity --progress --pulsate --title="Autoclean" --text="Aspetta il caricamento della barra"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoclean Effettuato";;

	"autoremove")apt-get autoremove | zenity --progress --pulsate --title="Autoremove" --text="Aspetta il caricamento della barra"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoremove Effettuato";;

	"purge")apt-get purge | zenity --title="Output Purge" --text-info #| zenity --progress --pulsate --title="Purge" --text="Aspetta il caricamento della barra"
			dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
				org.freedesktop.Notifications.SystemNoteInfoprint string:"Purge Effettuato";;

	"Update")conn=`ping -c 1 209.236.120.65 |grep 'received' | awk -F',' '{ print $2 }' | awk '{ print $1 }'`
		if [ "$conn" != "1" ]
			then
				ric=`zenity --warning --title CleaN900 --text "Occorre avere la connessione attiva, meglio se wifi. Se vuoi connetterti scegli Ok, altrimenti tappa nel vuoto";echo $?`
					if [ "$ric" = 0 ]
						then
							dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
							sleep 9
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connessione in corso... Attendere prego..."
							apt-get update | zenity --title="Output Update" --text-info
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completato" 
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione annullata"
					fi
	 
			else
				apt-get update | zenity --title="Output Update" --text-info
				dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completato"
		fi
;;

	"Upgrade")
		res=$(echo "n" | apt-get upgrade )
		if [ $? -eq 1 ]; then
			if zenity --title=Clean900 --question --text "$res"; then
					res=$(apt-get upgrade -f -y --force-yes)
					dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Aggiornamenti eseguiti"
				else
					dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Aggiornamenti non eseguiti!"
			fi
		fi
			zenity --title=Clean900 --info --text "$res"
			;;

	"Installa un pacchetto")
				pacchetto=`zenity --title CleaN900 --file-selection --text='Seleziona il deb' --filename=/home/user/MyDocs/ --file-filter "*.deb"`
					if [ $? -eq 0 ]; then
							dpkg -i $pacchetto | zenity --progress --pulsate --title="Installazione" --text="Aspetta il caricamento della barra"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Pacchetto Installato"
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione Annullata"
					fi
				;;				

	"Rimuovi pacchetto specifico")conn=`ping -c 1 209.236.120.65 |grep 'received' | awk -F',' '{ print $2 }' | awk '{ print $1 }'`
		if [ "$conn" != "1" ]
			then
				ric=`zenity --warning --title CleaN900 --text "Occorre avere la connessione attiva, meglio se wifi. Se vuoi connetterti scegli Ok, altrimenti tappa nel vuoto";echo $?`
					if [ "$ric" = 0 ]
						then
							dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connessione in corso... Attendere prego..."
							sleep 9
							pacchetto=`zenity --entry --title='Rimuovi' --text='Inserisci il nome del pacchetto'`
							dpkg -r $pacchetto | zenity --progress --pulsate --title="Disinstallazione" --text="Aspetta il caricamento della barra"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Pacchetto Disinstallato" #;;
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione annullata"
					fi
			else
				pacchetto=`zenity --entry --title='Rimuovi' --text='Inserisci il nome del pacchetto'`

					if [ $? -eq 0 ]; then
							dpkg -r $pacchetto | zenity --progress --pulsate --title="Disinstallazione" --text="Aspetta il caricamento della barra"
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Pacchetto Disinstallato"
						else
							dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione Annullata"
					fi
		fi
;;
	"Reboot")dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
			org.freedesktop.Notifications.SystemNoteInfoprint string:"Riavvio in corso... Attendere prego..."
				reboot;;

esac
done
	else
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Operazione annullata"
fi
