#ifndef CACHEPROVIDERPLUGIN_H
#define CACHEPROVIDERPLUGIN_H

#include <QDialog>
#include <QVBoxLayout>
#include <QGeoBoundingBox>
QTM_USE_NAMESPACE

#include "cache.h"
class CacheProvider;

class CacheProviderPlugin {

 public:
  virtual QString name() = 0;
  virtual QString license() = 0;
  virtual bool canBeDefault() = 0;
  virtual QObject *object() = 0;

  virtual void init(QWidget *) = 0;
  virtual void createConfig(QDialog *, QVBoxLayout*) = 0;

  virtual bool busy() = 0;
  virtual void processRequestOverview(const QGeoBoundingBox &, int, int) = 0;
  virtual void processRequestInfo(const QString &) = 0;
  virtual void processRequestDetail(const QString &) = 0;
};

Q_DECLARE_INTERFACE(CacheProviderPlugin,
      "org.harbaum.cacheme.cacheproviderplugin/1.0");

#endif // CACHEPROVIDERPLUGIN_H
