#include <QDebug>

#include "cachelist.h"

CacheList::CacheList(const QString &name) {
  this->m_name = (QString)name;
}

CacheList::CacheList() {
}

CacheList::~CacheList() {
}

void CacheList::append(Cache cache) {
  QList<Cache>::append(cache);
}

int CacheList::size() const {
  return QList<Cache>::size();
}

Cache CacheList::at(int index) {
  return QList<Cache>::at(index);
}

QString CacheList::name() {
  return m_name;
}

void CacheList::setName(const QString &name) {
  m_name = name;
}

QList<Cache>::const_iterator CacheList::begin() const {
  return QList<Cache>::begin();
}

QList<Cache>::const_iterator CacheList::end() const {
  return QList<Cache>::end();
}

QList<Cache>::iterator CacheList::begin() {
  return QList<Cache>::begin();
}

QList<Cache>::iterator CacheList::end() {
  return QList<Cache>::end();
}

void CacheList::clear() {
  qDebug() << __FUNCTION__;

  QList<Cache>::clear();
}

void CacheList::setDate(const QDate &date) {
  m_date = date;
}

QDate CacheList::date() const {
  return m_date;
}

// quicksort on distances
void CacheList::sort(qreal *dists, int left, int right) {
  if (left < right) {
    qreal pivot = dists[right];
    int l = left;
    int r = right;

    do {
      while( dists[l] < pivot) l++;
      while( dists[r] > pivot) r--;

      if (l <= r) {
	swap(l, r);
	qreal tmp = dists[l];
	dists[l] = dists[r];
	dists[r] = tmp;

	l++;
	r--;
      }
    } while (l <= r);

    sort(dists, left, r);
    sort(dists, l, right);
  }
}

void CacheList::sort(const QGeoCoordinate &coo) {
  // create distance table
  qreal *dists = new qreal [ size() ];
  QList<Cache>::const_iterator i;
  int j = 0;

  for(i = begin(); i != end(); ++i )
    dists[j++] = (*i).coordinate().distanceTo(coo);

  sort(dists, 0, size()-1);

  delete dists;
}

void CacheList::clip(const QGeoBoundingBox &bbox) {
  QList<Cache>::iterator i = begin();
  while (i != end()) {
    if(!bbox.contains((*i).coordinate()))
      i = erase(i);
    else
      ++i;
  }
}
