#include <QDebug>
#include <QtPlugin>

#include "none.h"
#include "cache.h"

#define PLUGIN_NAME "None"

None::None() { }

None::~None() { }

QString None::name() {
  return PLUGIN_NAME;
}

bool None::canBeDefault() {
  return true;
}

QString None::license() {
  return NULL;
}

QObject *None::object() {
  return this;
}

void None::init(QWidget *) {   
  qDebug() << PLUGIN_NAME << __FUNCTION__;
  emit reload();
}

bool None::busy() {
  return false;
}

void None::processRequestOverview(const QGeoBoundingBox &, const int) {
  qDebug() << PLUGIN_NAME << __FUNCTION__;
  
  CacheList cacheList(PLUGIN_NAME);

  emit done();
  emit replyOverview(cacheList);
  emit next();
}

void None::processRequestInfo(const QString &) {
  qDebug() << PLUGIN_NAME << __FUNCTION__;

  emit done();
  emit next();
}

void None::processRequestDetail(const QString &) {
  qDebug() << PLUGIN_NAME << __FUNCTION__;

  emit done();
  emit next();
}

void None::createConfig(QDialog *, QVBoxLayout *) { }

Q_EXPORT_PLUGIN2(none, None);
