/* libedataserver-1.2.vapi generated by lt-vapigen, do not modify. */

[CCode (cprefix = "E", lower_case_cprefix = "e_")]
namespace E {
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class Account : GLib.Object {
		public bool always_bcc;
		public bool always_cc;
		public weak string bcc_addrs;
		public weak string cc_addrs;
		public weak string drafts_folder_uri;
		public bool enabled;
		public weak E.AccountIdentity id;
		public weak string name;
		public weak string parent_uid;
		public bool pgp_always_sign;
		public bool pgp_always_trust;
		public bool pgp_encrypt_to_self;
		public weak string pgp_key;
		public bool pgp_no_imip_sign;
		public E.AccountReceiptPolicy receipt_policy;
		public weak string sent_folder_uri;
		public bool smime_encrypt_default;
		public weak string smime_encrypt_key;
		public bool smime_encrypt_to_self;
		public bool smime_sign_default;
		public weak string smime_sign_key;
		public weak E.AccountService source;
		public weak E.AccountService transport;
		public weak string uid;
		[CCode (has_construct_function = false)]
		public Account ();
		[CCode (has_construct_function = false)]
		public Account.from_xml (string xml);
		public bool get_bool (E.e_account_item_t type);
		public int get_int (E.e_account_item_t type);
		public unowned string get_string (E.e_account_item_t type);
		public void import (E.Account src);
		public void set_bool (E.e_account_item_t type, bool p3);
		public bool set_from_xml (string xml);
		public void set_int (E.e_account_item_t type, int p3);
		public void set_string (E.e_account_item_t type, string p3);
		public unowned string to_xml ();
		public static unowned string uid_from_xml (string xml);
		public bool writable (E.e_account_item_t type);
		public bool writable_option (string protocol, string option);
		public virtual signal void changed (int field);
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class AccountIdentity {
		public weak string address;
		public weak string name;
		public weak string organization;
		public weak string reply_to;
		public weak string sig_uid;
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class AccountList : E.List {
		[CCode (has_construct_function = false)]
		public AccountList (GConf.Client gconf);
		public int account_has_proxies (E.Account p2);
		public void add (E.Account p2);
		public void change (E.Account p2);
		public void @construct (GConf.Client gconf);
		public unowned E.Account find (E.e_account_find_t type, string key);
		public unowned E.Account get_default ();
		public void prune_proxies ();
		public void remove (E.Account p2);
		public void remove_account_proxies (E.Account p2);
		public void save ();
		public void set_default (E.Account p2);
		public virtual signal void account_added (E.Account p0);
		public virtual signal void account_changed (E.Account p0);
		public virtual signal void account_removed (E.Account p0);
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class AccountService {
		public bool auto_check;
		public int auto_check_time;
		public bool get_password_canceled;
		public bool keep_on_server;
		public bool save_passwd;
		public weak string url;
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class FileCache : GLib.Object {
		[CCode (has_construct_function = false)]
		public FileCache (string filename);
		public bool add_object (string key, string value);
		public bool clean ();
		public void freeze_changes ();
		public unowned string get_filename ();
		public unowned GLib.SList get_keys ();
		public unowned string get_object (string key);
		public unowned GLib.SList get_objects ();
		public bool remove ();
		public bool remove_object (string key);
		public bool replace_object (string key, string new_value);
		public void thaw_changes ();
		public string filename { get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class Flag {
		[CCode (has_construct_function = false)]
		public Flag ();
		public void clear ();
		public bool is_set ();
		public void @set ();
		public bool timed_wait (GLib.TimeVal abs_time);
		public void wait ();
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class Iterator : GLib.Object {
		public void @delete ();
		public virtual void* @get ();
		public virtual void insert (void* object, bool before);
		public virtual bool is_valid ();
		public virtual void last ();
		public virtual bool next ();
		public virtual bool prev ();
		[NoWrapper]
		public virtual void remove ();
		public virtual void reset ();
		public virtual void @set (void* object);
		public virtual signal void invalidate ();
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class List : GLib.Object {
		public void* closure;
		public weak E.ListCopyFunc copy;
		public weak E.ListFreeFunc free;
		public weak GLib.List iterators;
		public weak GLib.List list;
		[CCode (has_construct_function = false)]
		public List (E.ListCopyFunc copy, E.ListFreeFunc free, void* closure);
		public void append (void* data);
		public void @construct (E.ListCopyFunc copy, E.ListFreeFunc free, void* closure);
		public unowned E.List duplicate ();
		public unowned E.Iterator get_iterator ();
		public void invalidate_iterators (E.Iterator skip);
		public int length ();
		public void remove (void* data);
		public void remove_iterator (E.Iterator iterator);
		public void remove_link (GLib.List link);
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class ListIterator : E.Iterator {
		public weak GLib.List iterator;
		public weak E.List list;
		[CCode (type = "EIterator*", has_construct_function = false)]
		public ListIterator (E.List list);
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class MD5Context {
		[CCode (array_length = false)]
		public weak uint32[] bits;
		[CCode (array_length = false)]
		public weak uint32[] buf;
		[CCode (array_length = false)]
		public weak uchar[] @in;
	}
	[Compact]
	[CCode (free_function = "e_memchunk_destroy", cheader_filename = "libedataserver-1.2.h")]
	public class MemChunk {
		[CCode (cname = "e_memchunk_new", has_construct_function = false)]
		public MemChunk (int atomcount, int atomsize);
		[CCode (cname = "e_memchunk_alloc")]
		public void* alloc ();
		[CCode (cname = "e_memchunk_alloc0")]
		public void* alloc0 ();
		[CCode (cname = "e_memchunk_clean")]
		public void clean ();
		[CCode (cname = "e_memchunk_empty")]
		public void empty ();
		[CCode (cname = "e_memchunk_free")]
		public void free (void* mem);
	}
	[Compact]
	[CCode (free_function = "e_mempool_destroy", cheader_filename = "libedataserver-1.2.h")]
	public class MemPool {
		[CCode (cname = "e_mempool_new", has_construct_function = false)]
		public MemPool (int blocksize, int threshold, E.MemPoolFlags flags);
		[CCode (cname = "e_mempool_alloc")]
		public void* alloc (int size);
		[CCode (cname = "e_mempool_flush")]
		public void flush (int freeall);
		[CCode (cname = "e_mempool_strdup")]
		public unowned string strdup (string str);
	}
	[Compact]
	[CCode (free_function = "e_poolv_destroy", cheader_filename = "libedataserver-1.2.h")]
	public class Poolv {
		[CCode (has_construct_function = false)]
		public Poolv (uint size);
		public unowned E.Poolv cpy (E.Poolv src);
		public unowned string @get (int index);
		public unowned E.Poolv @set (int index, string str, int freeit);
	}
	[Compact]
	[CCode (ref_function = "e_sexp_ref", ref_function_void = true, unref_function = "e_sexp_unref", cheader_filename = "libedataserver-1.2.h")]
	public class SExp {
		public weak string error;
		public int refcount;
		public void* result_chunks;
		public weak GLib.Scanner scanner;
		public void* term_chunks;
		public weak E.SExpTerm tree;
		[CCode (has_construct_function = false)]
		public SExp ();
		public void add_function (int scope, string name, E.SExpFunc func, void* data);
		public void add_ifunction (int scope, string name, E.SExpIFunc func, void* data);
		public void add_variable (int scope, string name, E.SExpTerm value);
		public static void encode_bool (GLib.StringBuilder s, bool state);
		public static void encode_string (GLib.StringBuilder s, string str);
		public unowned E.SExpResult eval ();
		public static void fatal_error (void* f, string why);
		public void input_file (int fd);
		public void input_text (string text, int len);
		public int parse ();
		public void remove_symbol (int scope, string name);
		public static void resultv_free (void* f, int argc, void* argv);
		public int set_scope (int scope);
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpClass {
		public int dummy;
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpFunc {
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpIFunc {
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpResult {
		public void* value;
		[CCode (has_construct_function = false)]
		public SExpResult (void* f, int type);
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpSymbol {
		public void* data;
		public void* f;
		public weak string name;
		public int type;
	}
	[Compact]
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SExpTerm {
		public void* value;
		public static unowned E.SExpResult eval (void* f, void* t);
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class Source : GLib.Object {
		[CCode (has_construct_function = false)]
		public Source (string name, string relative_uri);
		public unowned string build_absolute_uri ();
		public unowned E.Source copy ();
		public void dump_to_xml_node (Xml.Node parent_node);
		public bool equal (E.Source source_2);
		public void foreach_property (GLib.HFunc func, void* data);
		[CCode (has_construct_function = false)]
		public Source.from_standalone_xml (string xml);
		[CCode (has_construct_function = false)]
		public Source.from_xml_node (Xml.Node node);
		public bool get_color (uint32 color_return);
		public unowned string get_duped_property (string property);
		public unowned string get_property (string property);
		public bool get_readonly ();
		public unowned string get_uri ();
		public unowned string peek_absolute_uri ();
		public unowned string peek_color_spec ();
		public unowned E.SourceGroup peek_group ();
		public unowned string peek_name ();
		public unowned string peek_relative_uri ();
		public unowned string peek_uid ();
		public void set_absolute_uri (string absolute_uri);
		public void set_color (uint32 color);
		public void set_color_spec (string color_spec);
		public void set_group (E.SourceGroup group);
		public void set_name (string name);
		public void set_property (string property, string value);
		public void set_readonly (bool readonly);
		public void set_relative_uri (string relative_uri);
		public unowned string to_standalone_xml ();
		public static unowned string uid_from_xml_node (Xml.Node node);
		public void unset_color ();
		public bool update_from_xml_node (Xml.Node node, bool changed_return);
		[CCode (has_construct_function = false)]
		public Source.with_absolute_uri (string name, string absolute_uri);
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SourceGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceGroup (string name, string base_uri);
		public bool add_source (E.Source source, int position);
		public void foreach_property (GLib.HFunc func, void* data);
		[CCode (has_construct_function = false)]
		public SourceGroup.from_xml (string xml);
		[CCode (has_construct_function = false)]
		public SourceGroup.from_xmldoc (Xml.Doc doc);
		public unowned string get_property (string property);
		public bool get_readonly ();
		public unowned string peek_base_uri ();
		public unowned string peek_name ();
		public unowned E.Source peek_source_by_name (string source_name);
		public unowned E.Source peek_source_by_uid (string source_uid);
		public unowned GLib.SList peek_sources ();
		public unowned string peek_uid ();
		public bool remove_source (E.Source source);
		public bool remove_source_by_uid (string uid);
		public void set_base_uri (string base_uri);
		public void set_name (string name);
		public void set_property (string property, string value);
		public void set_readonly (bool readonly);
		public unowned string to_xml ();
		public static unowned string uid_from_xmldoc (Xml.Doc doc);
		public bool update_from_xml (string xml, bool changed_return);
		public bool update_from_xmldoc (Xml.Doc doc, bool changed_return);
		public virtual signal void changed ();
		public virtual signal void source_added (GLib.Object source);
		public virtual signal void source_removed (GLib.Object source);
	}
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public class SourceList : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceList ();
		public bool add_group (E.SourceGroup group, int position);
		[CCode (has_construct_function = false)]
		public SourceList.for_gconf (GConf.Client client, string path);
		[CCode (has_construct_function = false)]
		public SourceList.for_gconf_default (string path);
		public bool is_gconf_updated ();
		public unowned E.SourceGroup peek_group_by_name (string name);
		public unowned E.SourceGroup peek_group_by_uid (string uid);
		public unowned GLib.SList peek_groups ();
		public unowned E.Source peek_source_any ();
		public unowned E.Source peek_source_by_uid (string uid);
		public bool remove_group (E.SourceGroup group);
		public bool remove_group_by_uid (string uid);
		public bool remove_source_by_uid (string uidj);
		public bool sync () throws GLib.Error;
		public virtual signal void changed ();
		public virtual signal void group_added (void* group);
		public virtual signal void group_removed (void* group);
	}
	[Compact]
	[CCode (free_function = "e_strv_destroy", cheader_filename = "libedataserver-1.2.h")]
	public class Strv {
		[CCode (has_construct_function = false)]
		public Strv (int size);
		public unowned string @get (int index);
		public unowned E.Strv pack ();
		public unowned E.Strv @set (int index, string str);
		public unowned E.Strv set_ref (int index, string str);
		public unowned E.Strv set_ref_free (int index, string str);
	}
	[Compact]
	[CCode (copy_function = "e_uri_copy", cheader_filename = "libedataserver-1.2.h")]
	public class Uri {
		public weak string authmech;
		public weak string fragment;
		public weak string host;
		public weak string passwd;
		public weak string path;
		public int port;
		public weak string protocol;
		public weak string query;
		public weak string user;
		[CCode (has_construct_function = false)]
		public Uri (string uri_string);
		public unowned E.Uri copy ();
		public unowned string get_param (string name);
		public unowned string to_string (bool show_password);
	}
	[Compact]
	[CCode (free_function = "e_xmlhash_destroy", cheader_filename = "libedataserver-1.2.h")]
	public class XmlHash {
		[CCode (cname = "e_xmlhash_new", has_construct_function = false)]
		public XmlHash (string filename);
		[CCode (cname = "e_xmlhash_add")]
		public void add (string key, string data);
		[CCode (cname = "e_xmlhash_compare")]
		public E.XmlHashStatus compare (string key, string compare_data);
		[CCode (cname = "e_xmlhash_foreach_key")]
		public void foreach_key (E.XmlHashFunc func);
		[CCode (cname = "e_xmlhash_foreach_key_remove")]
		public void foreach_key_remove (E.XmlHashRemoveFunc func);
		[CCode (cname = "e_xmlhash_remove")]
		public void remove (string key);
		[CCode (cname = "e_xmlhash_write")]
		public void write ();
	}
	[CCode (cprefix = "E_ACCOUNT_RECEIPT_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum AccountReceiptPolicy {
		NEVER,
		ASK,
		ALWAYS
	}
	[CCode (cprefix = "E_MEMPOOL_ALIGN_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum MemPoolFlags {
		STRUCT,
		WORD,
		BYTE,
		MASK
	}
	[CCode (cprefix = "E_TIME_PARSE_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum TimeParseStatus {
		OK,
		NONE,
		INVALID
	}
	[CCode (cprefix = "E_XMLHASH_STATUS_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum XmlHashStatus {
		SAME,
		DIFFERENT,
		NOT_FOUND
	}
	[CCode (cprefix = "E_XML_HASH_TYPE_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum XmlHashType {
		OBJECT_UID,
		PROPERTY
	}
	[CCode (cprefix = "E_ACCOUNT_ACCESS_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum e_account_access_t {
		WRITE
	}
	[CCode (cprefix = "E_ACCOUNT_FIND_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum e_account_find_t {
		NAME,
		UID,
		ID_NAME,
		ID_ADDRESS,
		PARENT_UID
	}
	[CCode (cprefix = "E_ACCOUNT_", has_type_id = "0", cheader_filename = "libedataserver-1.2.h")]
	public enum e_account_item_t {
		NAME,
		ID_NAME,
		ID_ADDRESS,
		ID_REPLY_TO,
		ID_ORGANIZATION,
		ID_SIGNATURE,
		SOURCE_URL,
		SOURCE_KEEP_ON_SERVER,
		SOURCE_AUTO_CHECK,
		SOURCE_AUTO_CHECK_TIME,
		SOURCE_SAVE_PASSWD,
		TRANSPORT_URL,
		TRANSPORT_SAVE_PASSWD,
		DRAFTS_FOLDER_URI,
		SENT_FOLDER_URI,
		CC_ALWAYS,
		CC_ADDRS,
		BCC_ALWAYS,
		BCC_ADDRS,
		RECEIPT_POLICY,
		PGP_KEY,
		PGP_ENCRYPT_TO_SELF,
		PGP_ALWAYS_SIGN,
		PGP_NO_IMIP_SIGN,
		PGP_ALWAYS_TRUST,
		SMIME_SIGN_KEY,
		SMIME_ENCRYPT_KEY,
		SMIME_SIGN_DEFAULT,
		SMIME_ENCRYPT_TO_SELF,
		SMIME_ENCRYPT_DEFAULT,
		PROXY_PARENT_UID,
		ITEM_LAST
	}
	[CCode (cheader_filename = "libedataserver-1.2.h", has_target = false)]
	public delegate void* ListCopyFunc (void* data, void* closure);
	[CCode (cheader_filename = "libedataserver-1.2.h", has_target = false)]
	public delegate void ListFreeFunc (void* data, void* closure);
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public delegate void XmlHashFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public delegate bool XmlHashRemoveFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public const int LOG_INVALID_DOMAIN;
	[CCode (cheader_filename = "libedataserver-1.2.h")]
	public const int TYPE_SEXP;
	[CCode (cname = "e_categories_add", cheader_filename = "libedataserver-1.2.h")]
	public static void e_categories_add (string category, string unused, string icon_file, bool searchable);
	[CCode (cname = "e_categories_exist", cheader_filename = "libedataserver-1.2.h")]
	public static bool e_categories_exist (string category);
	[CCode (cname = "e_categories_get_color_for", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_categories_get_color_for (string category);
	[CCode (cname = "e_categories_get_icon_file_for", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_categories_get_icon_file_for (string category);
	[CCode (cname = "e_categories_get_list", cheader_filename = "libedataserver-1.2.h")]
	public static unowned GLib.List e_categories_get_list ();
	[CCode (cname = "e_categories_is_searchable", cheader_filename = "libedataserver-1.2.h")]
	public static bool e_categories_is_searchable (string category);
	[CCode (cname = "e_categories_remove", cheader_filename = "libedataserver-1.2.h")]
	public static void e_categories_remove (string category);
	[CCode (cname = "e_categories_set_color_for", cheader_filename = "libedataserver-1.2.h")]
	public static void e_categories_set_color_for (string category, string color);
	[CCode (cname = "e_categories_set_icon_file_for", cheader_filename = "libedataserver-1.2.h")]
	public static void e_categories_set_icon_file_for (string category, string icon_file);
	[CCode (cname = "e_filename_make_safe", cheader_filename = "libedataserver-1.2.h")]
	public static void e_filename_make_safe (string str);
	[CCode (cname = "e_localtime_with_offset", cheader_filename = "libedataserver-1.2.h")]
	public static void e_localtime_with_offset (ulong tt, void* tm, int offset);
	[CCode (cname = "e_log_get_id", cheader_filename = "libedataserver-1.2.h")]
	public static int e_log_get_id (string domain);
	[CCode (cname = "e_log_real", cheader_filename = "libedataserver-1.2.h")]
	public static void e_log_real (int domain_id, GLib.LogLevelFlags log_level, string format);
	[CCode (cname = "e_log_set_domains", cheader_filename = "libedataserver-1.2.h")]
	public static void e_log_set_domains (string domains);
	[CCode (cname = "e_log_set_level", cheader_filename = "libedataserver-1.2.h")]
	public static void e_log_set_level (GLib.LogLevelFlags log_level);
	[CCode (cname = "e_log_set_level_from_string", cheader_filename = "libedataserver-1.2.h")]
	public static void e_log_set_level_from_string (string str);
	[CCode (cname = "e_log_will_print", cheader_filename = "libedataserver-1.2.h")]
	public static bool e_log_will_print (int domain_id, GLib.LogLevelFlags log_level);
	[CCode (cname = "e_mktime_utc", cheader_filename = "libedataserver-1.2.h")]
	public static ulong e_mktime_utc (void* tm);
	[CCode (cname = "e_strftime", cheader_filename = "libedataserver-1.2.h")]
	public static size_t e_strftime (string s, size_t max, string fmt, void* tm);
	[CCode (cname = "e_time_format_date_and_time", cheader_filename = "libedataserver-1.2.h")]
	public static void e_time_format_date_and_time (void* date_tm, bool use_24_hour_format, bool show_midnight, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cname = "e_time_format_time", cheader_filename = "libedataserver-1.2.h")]
	public static void e_time_format_time (void* date_tm, bool use_24_hour_format, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cname = "e_time_get_d_fmt_with_4digit_year", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_time_get_d_fmt_with_4digit_year ();
	[CCode (cname = "e_time_parse_date", cheader_filename = "libedataserver-1.2.h")]
	public static E.TimeParseStatus e_time_parse_date (string value, void* _result);
	[CCode (cname = "e_time_parse_date_and_time", cheader_filename = "libedataserver-1.2.h")]
	public static E.TimeParseStatus e_time_parse_date_and_time (string value, void* _result);
	[CCode (cname = "e_time_parse_date_and_time_ex", cheader_filename = "libedataserver-1.2.h")]
	public static E.TimeParseStatus e_time_parse_date_and_time_ex (string value, void* _result, bool two_digit_year);
	[CCode (cname = "e_time_parse_date_ex", cheader_filename = "libedataserver-1.2.h")]
	public static E.TimeParseStatus e_time_parse_date_ex (string value, void* _result, bool two_digit_year);
	[CCode (cname = "e_time_parse_time", cheader_filename = "libedataserver-1.2.h")]
	public static E.TimeParseStatus e_time_parse_time (string value, void* _result);
	[CCode (cname = "e_uid_new", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_uid_new ();
	[CCode (cname = "e_url_equal", cheader_filename = "libedataserver-1.2.h")]
	public static bool e_url_equal (string url1, string url2);
	[CCode (cname = "e_url_shroud", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_url_shroud (string url);
	[CCode (cname = "e_utf8_strftime", cheader_filename = "libedataserver-1.2.h")]
	public static size_t e_utf8_strftime (string s, size_t max, string fmt, void* tm);
	[CCode (cname = "e_util_mkdir_hier", cheader_filename = "libedataserver-1.2.h")]
	public static int e_util_mkdir_hier (string path, uint mode);
	[CCode (cname = "e_util_strstrcase", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_util_strstrcase (string haystack, string needle);
	[CCode (cname = "e_util_unicode_get_utf8", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_util_unicode_get_utf8 (string text, unichar @out);
	[CCode (cname = "e_util_utf8_strcasecmp", cheader_filename = "libedataserver-1.2.h")]
	public static int e_util_utf8_strcasecmp (string s1, string s2);
	[CCode (cname = "e_util_utf8_strstrcase", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_util_utf8_strstrcase (string haystack, string needle);
	[CCode (cname = "e_util_utf8_strstrcasedecomp", cheader_filename = "libedataserver-1.2.h")]
	public static unowned string e_util_utf8_strstrcasedecomp (string haystack, string needle);
	[CCode (cname = "e_xml_destroy_hash", cheader_filename = "libedataserver-1.2.h")]
	public static void e_xml_destroy_hash (GLib.HashTable hash);
	[CCode (cname = "e_xml_from_hash", cheader_filename = "libedataserver-1.2.h")]
	public static unowned Xml.Doc e_xml_from_hash (GLib.HashTable hash, E.XmlHashType type, string root_node);
	[CCode (cname = "e_xml_get_child_by_name", cheader_filename = "libedataserver-1.2.h")]
	public static unowned Xml.Node e_xml_get_child_by_name (Xml.Node parent, string child_name);
	[CCode (cname = "e_xml_parse_file", cheader_filename = "libedataserver-1.2.h")]
	public static unowned Xml.Doc e_xml_parse_file (string filename);
	[CCode (cname = "e_xml_save_file", cheader_filename = "libedataserver-1.2.h")]
	public static int e_xml_save_file (string filename, Xml.Doc doc);
	[CCode (cname = "e_xml_to_hash", cheader_filename = "libedataserver-1.2.h")]
	public static unowned GLib.HashTable e_xml_to_hash (Xml.Doc doc, E.XmlHashType type);
	[CCode (cname = "eds_module_initialize", cheader_filename = "libedataserver-1.2.h")]
	public static void eds_module_initialize (GLib.TypeModule module);
	[CCode (cname = "eds_module_list_types", cheader_filename = "libedataserver-1.2.h")]
	public static void eds_module_list_types (GLib.Type[] types, int num_types);
	[CCode (cname = "eds_module_shutdown", cheader_filename = "libedataserver-1.2.h")]
	public static void eds_module_shutdown ();
	[CCode (cname = "e_data_server_extension_list_free", cheader_filename = "libedataserver-1.2.h")]
	public static void extension_list_free (GLib.List list);
	[CCode (cname = "e_data_server_get_extensions_for_type", cheader_filename = "libedataserver-1.2.h")]
	public static unowned GLib.List get_extensions_for_type (GLib.Type type);
	[CCode (cname = "md5_final", cheader_filename = "libedataserver-1.2.h")]
	public static void md5_final (E.MD5Context ctx, uchar[] digest);
	[CCode (cname = "md5_get_digest", cheader_filename = "libedataserver-1.2.h")]
	public static void md5_get_digest (string buffer, int buffer_size, uchar[] digest);
	[CCode (cname = "md5_get_digest_from_file", cheader_filename = "libedataserver-1.2.h")]
	public static void md5_get_digest_from_file (string filename, uchar[] digest);
	[CCode (cname = "md5_init", cheader_filename = "libedataserver-1.2.h")]
	public static void md5_init (E.MD5Context ctx);
	[CCode (cname = "md5_update", cheader_filename = "libedataserver-1.2.h")]
	public static void md5_update (E.MD5Context ctx, uchar[] buf, uint32 len);
	[CCode (cname = "e_data_server_module_add_type", cheader_filename = "libedataserver-1.2.h")]
	public static void module_add_type (GLib.Type type);
	[CCode (cname = "e_data_server_module_init", cheader_filename = "libedataserver-1.2.h")]
	public static void module_init ();
	[CCode (cname = "e_data_server_module_remove_unused", cheader_filename = "libedataserver-1.2.h")]
	public static void module_remove_unused ();
}
